/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.api.core;

import java.security.AccessControlException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.security.auth.Subject;
import org.apache.wiki.event.WikiEventListener;

public interface Session
extends WikiEventListener {
    public static final String ANONYMOUS = "anonymous";
    public static final String ASSERTED = "asserted";
    public static final String AUTHENTICATED = "authenticated";

    public boolean isAsserted();

    public boolean isAuthenticated();

    public boolean isAnonymous();

    public Principal getLoginPrincipal();

    public Principal getUserPrincipal();

    public String antiCsrfToken();

    public Locale getLocale();

    public void addMessage(String var1);

    public void addMessage(String var1, String var2);

    public void clearMessages();

    public void clearMessages(String var1);

    public String[] getMessages();

    public String[] getMessages(String var1);

    public Principal[] getPrincipals();

    public Principal[] getRoles();

    public boolean hasPrincipal(Principal var1);

    public void invalidate();

    public String getStatus();

    public Subject getSubject();

    public static Object doPrivileged(Session session, PrivilegedAction<?> action) throws AccessControlException {
        return Subject.doAsPrivileged(session.getSubject(), action, null);
    }
}

