/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import com.yammer.metrics.core.MetricName;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class RemoteStorageMetrics {
    private static final String REMOTE_LOG_READER_METRICS_NAME_PREFIX = "RemoteLogReader";
    private static final String REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT = "RemoteLogManagerTasksAvgIdlePercent";
    private static final String TASK_QUEUE_SIZE = "TaskQueueSize";
    private static final String AVG_IDLE_PERCENT = "AvgIdlePercent";
    private static final String REMOTE_COPY_BYTES_PER_SEC = "RemoteCopyBytesPerSec";
    private static final String REMOTE_FETCH_BYTES_PER_SEC = "RemoteFetchBytesPerSec";
    private static final String REMOTE_FETCH_REQUESTS_PER_SEC = "RemoteFetchRequestsPerSec";
    private static final String REMOTE_COPY_REQUESTS_PER_SEC = "RemoteCopyRequestsPerSec";
    private static final String REMOTE_DELETE_REQUESTS_PER_SEC = "RemoteDeleteRequestsPerSec";
    private static final String BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC = "BuildRemoteLogAuxStateRequestsPerSec";
    private static final String FAILED_REMOTE_FETCH_PER_SEC = "RemoteFetchErrorsPerSec";
    private static final String FAILED_REMOTE_COPY_PER_SEC = "RemoteCopyErrorsPerSec";
    private static final String REMOTE_LOG_METADATA_COUNT = "RemoteLogMetadataCount";
    private static final String REMOTE_LOG_SIZE_BYTES = "RemoteLogSizeBytes";
    private static final String REMOTE_LOG_SIZE_COMPUTATION_TIME = "RemoteLogSizeComputationTime";
    private static final String FAILED_REMOTE_DELETE_PER_SEC = "RemoteDeleteErrorsPerSec";
    private static final String FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC = "BuildRemoteLogAuxStateErrorsPerSec";
    private static final String REMOTE_COPY_LAG_BYTES = "RemoteCopyLagBytes";
    private static final String REMOTE_COPY_LAG_SEGMENTS = "RemoteCopyLagSegments";
    private static final String REMOTE_DELETE_LAG_BYTES = "RemoteDeleteLagBytes";
    private static final String REMOTE_DELETE_LAG_SEGMENTS = "RemoteDeleteLagSegments";
    private static final String REMOTE_LOG_READER_TASK_QUEUE_SIZE = "RemoteLogReaderTaskQueueSize";
    private static final String REMOTE_LOG_READER_AVG_IDLE_PERCENT = "RemoteLogReaderAvgIdlePercent";
    public static final Set<String> REMOTE_STORAGE_THREAD_POOL_METRICS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("RemoteLogReaderTaskQueueSize", "RemoteLogReaderAvgIdlePercent")));
    public static final MetricName REMOTE_COPY_BYTES_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyBytesPerSec");
    public static final MetricName REMOTE_FETCH_BYTES_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteFetchBytesPerSec");
    public static final MetricName REMOTE_FETCH_REQUESTS_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteFetchRequestsPerSec");
    public static final MetricName REMOTE_COPY_REQUESTS_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyRequestsPerSec");
    public static final MetricName REMOTE_DELETE_REQUESTS_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteDeleteRequestsPerSec");
    public static final MetricName BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "BuildRemoteLogAuxStateRequestsPerSec");
    public static final MetricName FAILED_REMOTE_FETCH_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteFetchErrorsPerSec");
    public static final MetricName FAILED_REMOTE_COPY_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyErrorsPerSec");
    public static final MetricName REMOTE_LOG_METADATA_COUNT_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteLogMetadataCount");
    public static final MetricName REMOTE_LOG_SIZE_BYTES_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteLogSizeBytes");
    public static final MetricName REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteLogSizeComputationTime");
    public static final MetricName FAILED_REMOTE_DELETE_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteDeleteErrorsPerSec");
    public static final MetricName FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "BuildRemoteLogAuxStateErrorsPerSec");
    public static final MetricName REMOTE_COPY_LAG_BYTES_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyLagBytes");
    public static final MetricName REMOTE_COPY_LAG_SEGMENTS_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyLagSegments");
    public static final MetricName REMOTE_DELETE_LAG_BYTES_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteDeleteLagBytes");
    public static final MetricName REMOTE_DELETE_LAG_SEGMENTS_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteDeleteLagSegments");
    public static final MetricName REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT_METRIC = RemoteStorageMetrics.getMetricName("kafka.log.remote", "RemoteLogManager", "RemoteLogManagerTasksAvgIdlePercent");
    public static final MetricName REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC = RemoteStorageMetrics.getMetricName("org.apache.kafka.storage.internals.log", "RemoteStorageThreadPool", "RemoteLogReaderTaskQueueSize");
    public static final MetricName REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC = RemoteStorageMetrics.getMetricName("org.apache.kafka.storage.internals.log", "RemoteStorageThreadPool", "RemoteLogReaderAvgIdlePercent");

    public static Set<MetricName> allMetrics() {
        HashSet<MetricName> metrics = new HashSet<MetricName>();
        metrics.add(REMOTE_COPY_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_REQUESTS_PER_SEC_METRIC);
        metrics.add(REMOTE_COPY_REQUESTS_PER_SEC_METRIC);
        metrics.add(REMOTE_DELETE_REQUESTS_PER_SEC_METRIC);
        metrics.add(BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_FETCH_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_COPY_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_DELETE_PER_SEC_METRIC);
        metrics.add(FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC);
        metrics.add(REMOTE_COPY_LAG_BYTES_METRIC);
        metrics.add(REMOTE_COPY_LAG_SEGMENTS_METRIC);
        metrics.add(REMOTE_DELETE_LAG_BYTES_METRIC);
        metrics.add(REMOTE_DELETE_LAG_SEGMENTS_METRIC);
        metrics.add(REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT_METRIC);
        metrics.add(REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC);
        metrics.add(REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC);
        metrics.add(REMOTE_LOG_METADATA_COUNT_METRIC);
        metrics.add(REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC);
        metrics.add(REMOTE_LOG_SIZE_BYTES_METRIC);
        return metrics;
    }

    public static Set<MetricName> brokerTopicStatsMetrics() {
        HashSet<MetricName> metrics = new HashSet<MetricName>();
        metrics.add(REMOTE_COPY_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_REQUESTS_PER_SEC_METRIC);
        metrics.add(REMOTE_COPY_REQUESTS_PER_SEC_METRIC);
        metrics.add(REMOTE_DELETE_REQUESTS_PER_SEC_METRIC);
        metrics.add(BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_FETCH_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_COPY_PER_SEC_METRIC);
        metrics.add(REMOTE_LOG_METADATA_COUNT_METRIC);
        metrics.add(REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC);
        metrics.add(REMOTE_LOG_SIZE_BYTES_METRIC);
        metrics.add(FAILED_REMOTE_DELETE_PER_SEC_METRIC);
        metrics.add(FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC);
        metrics.add(REMOTE_COPY_LAG_BYTES_METRIC);
        metrics.add(REMOTE_COPY_LAG_SEGMENTS_METRIC);
        metrics.add(REMOTE_DELETE_LAG_BYTES_METRIC);
        metrics.add(REMOTE_DELETE_LAG_SEGMENTS_METRIC);
        return metrics;
    }

    private static MetricName getMetricName(String group, String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)group, (String)type, (String)name);
    }
}

