/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.errors;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.controller.errors.ControllerExceptions;
import org.apache.kafka.raft.errors.NotLeaderException;
import org.apache.kafka.raft.errors.UnexpectedBaseOffsetException;
import org.apache.kafka.server.mutable.BoundedListTooLongException;

public final class EventHandlerExceptionInfo {
    private final boolean isFault;
    private final boolean causesFailover;
    private final Throwable internalException;
    private final Optional<Throwable> externalException;

    public static EventHandlerExceptionInfo fromInternal(Throwable internal, Supplier<OptionalInt> latestControllerSupplier) {
        if (internal instanceof ApiException) {
            return new EventHandlerExceptionInfo(false, false, internal);
        }
        if (internal instanceof NotLeaderException) {
            return new EventHandlerExceptionInfo(false, true, internal, (Throwable)ControllerExceptions.newWrongControllerException(latestControllerSupplier.get()));
        }
        if (internal instanceof RejectedExecutionException) {
            return new EventHandlerExceptionInfo(false, false, internal, (Throwable)new TimeoutException("The controller is shutting down.", internal));
        }
        if (internal instanceof BoundedListTooLongException) {
            return new EventHandlerExceptionInfo(false, false, internal, new PolicyViolationException("Unable to perform excessively large batch operation."));
        }
        if (internal instanceof UnexpectedBaseOffsetException) {
            return new EventHandlerExceptionInfo(false, true, internal, (Throwable)new NotControllerException("Unexpected end offset. Controller will resign."));
        }
        if (internal instanceof InterruptedException) {
            return new EventHandlerExceptionInfo(true, true, internal, (Throwable)new UnknownServerException("The controller was interrupted."));
        }
        return new EventHandlerExceptionInfo(true, true, internal, (Throwable)new UnknownServerException(internal));
    }

    static boolean exceptionClassesAndMessagesMatch(Throwable a, Throwable b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        return Objects.equals(a.getMessage(), b.getMessage());
    }

    EventHandlerExceptionInfo(boolean isFault, boolean causesFailover, Throwable internalException) {
        this.isFault = isFault;
        this.causesFailover = causesFailover;
        this.internalException = internalException;
        this.externalException = Optional.empty();
    }

    EventHandlerExceptionInfo(boolean isFault, boolean causesFailover, Throwable internalException, Throwable externalException) {
        this.isFault = isFault;
        this.causesFailover = causesFailover;
        this.internalException = internalException;
        this.externalException = Optional.of(externalException);
    }

    public boolean isFault() {
        return this.isFault;
    }

    public boolean causesFailover() {
        return this.causesFailover;
    }

    public Throwable effectiveExternalException() {
        return this.externalException.orElse(this.internalException);
    }

    public boolean isTimeoutException() {
        return this.internalException instanceof TimeoutException;
    }

    public String failureMessage(int epoch, OptionalLong deltaUs, boolean isActiveController, long lastCommittedOffset) {
        StringBuilder bld = new StringBuilder();
        if (deltaUs.isPresent()) {
            bld.append("event failed with ");
        } else {
            bld.append("event unable to start processing because of ");
        }
        bld.append(this.internalException.getClass().getSimpleName());
        if (this.externalException.isPresent()) {
            bld.append(" (treated as ").append(this.externalException.get().getClass().getSimpleName()).append(")");
        }
        if (this.causesFailover()) {
            bld.append(" at epoch ").append(epoch);
        }
        if (deltaUs.isPresent()) {
            bld.append(" in ").append(deltaUs.getAsLong()).append(" microseconds");
        }
        if (this.causesFailover()) {
            if (isActiveController) {
                bld.append(". Renouncing leadership and reverting to the last committed offset ");
                bld.append(lastCommittedOffset);
            } else {
                bld.append(". The controller is already in standby mode");
            }
        }
        bld.append(".");
        if (!this.isFault && this.internalException.getMessage() != null) {
            bld.append(" Exception message: ");
            bld.append(this.internalException.getMessage());
        }
        return bld.toString();
    }

    public int hashCode() {
        return Objects.hash(this.isFault, this.causesFailover, this.internalException.getClass().getCanonicalName(), this.internalException.getMessage(), this.externalException.orElse(this.internalException).getClass().getCanonicalName(), this.externalException.orElse(this.internalException).getMessage());
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(EventHandlerExceptionInfo.class)) {
            return false;
        }
        EventHandlerExceptionInfo other = (EventHandlerExceptionInfo)o;
        return this.isFault == other.isFault && this.causesFailover == other.causesFailover && EventHandlerExceptionInfo.exceptionClassesAndMessagesMatch(this.internalException, other.internalException) && EventHandlerExceptionInfo.exceptionClassesAndMessagesMatch(this.externalException.orElse(null), other.externalException.orElse(null));
    }

    public String toString() {
        return "EventHandlerExceptionInfo(isFault=" + this.isFault + ", causesFailover=" + this.causesFailover + ", internalException.class=" + this.internalException.getClass().getCanonicalName() + ", externalException.class=" + (this.externalException.isPresent() ? this.externalException.get().getClass().getCanonicalName() : "(none)") + ")";
    }
}

