/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tools.TerseException;

public class EndToEndLatency {
    private static final long POLL_TIMEOUT_MS = 60000L;
    private static final short DEFAULT_REPLICATION_FACTOR = 1;
    private static final int DEFAULT_NUM_PARTITIONS = 1;

    public static void main(String ... args) {
        Exit.exit((int)EndToEndLatency.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            EndToEndLatency.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    static void execute(String ... args) throws Exception {
        Optional<String> propertiesFile;
        if (args.length != 5 && args.length != 6) {
            throw new TerseException("USAGE: java " + EndToEndLatency.class.getName() + " broker_list topic num_messages producer_acks message_size_bytes [optional] properties_file");
        }
        String brokers = args[0];
        String topic = args[1];
        int numMessages = Integer.parseInt(args[2]);
        String acks = args[3];
        int messageSizeBytes = Integer.parseInt(args[4]);
        Optional<String> optional = propertiesFile = args.length > 5 && !Utils.isBlank((String)args[5]) ? Optional.of(args[5]) : Optional.empty();
        if (!Arrays.asList("1", "all").contains(acks)) {
            throw new IllegalArgumentException("Latency testing requires synchronous acknowledgement. Please use 1 or all");
        }
        try (KafkaConsumer<byte[], byte[]> consumer = EndToEndLatency.createKafkaConsumer(propertiesFile, brokers);
             KafkaProducer<byte[], byte[]> producer = EndToEndLatency.createKafkaProducer(propertiesFile, brokers, acks);){
            if (!consumer.listTopics().containsKey(topic)) {
                EndToEndLatency.createTopic(propertiesFile, brokers, topic);
            }
            EndToEndLatency.setupConsumer(topic, consumer);
            double totalTime = 0.0;
            long[] latencies = new long[numMessages];
            Random random = new Random(0L);
            for (int i = 0; i < numMessages; ++i) {
                byte[] message = EndToEndLatency.randomBytesOfLen(random, messageSizeBytes);
                long begin = System.nanoTime();
                producer.send(new ProducerRecord(topic, (Object)message)).get();
                ConsumerRecords records = consumer.poll(Duration.ofMillis(60000L));
                long elapsed = System.nanoTime() - begin;
                EndToEndLatency.validate(consumer, message, (ConsumerRecords<byte[], byte[]>)records);
                if (i % 1000 == 0) {
                    System.out.println(i + "\t" + (double)elapsed / 1000.0 / 1000.0);
                }
                totalTime += (double)elapsed;
                latencies[i] = elapsed / 1000L / 1000L;
            }
            EndToEndLatency.printResults(numMessages, totalTime, latencies);
            consumer.commitSync();
        }
    }

    static void validate(KafkaConsumer<byte[], byte[]> consumer, byte[] message, ConsumerRecords<byte[], byte[]> records) {
        if (records.isEmpty()) {
            consumer.commitSync();
            throw new RuntimeException("poll() timed out before finding a result (timeout:[60000])");
        }
        String sent = new String(message, StandardCharsets.UTF_8);
        String read = new String((byte[])((ConsumerRecord)records.iterator().next()).value(), StandardCharsets.UTF_8);
        if (!read.equals(sent)) {
            consumer.commitSync();
            throw new RuntimeException("The message read [" + read + "] did not match the message sent [" + sent + "]");
        }
        if (records.count() != 1) {
            int count = records.count();
            consumer.commitSync();
            throw new RuntimeException("Only one result was expected during this test. We found [" + count + "]");
        }
    }

    private static void setupConsumer(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        List topicPartitions = consumer.partitionsFor(topic).stream().map(p -> new TopicPartition(p.topic(), p.partition())).collect(Collectors.toList());
        consumer.assign(topicPartitions);
        consumer.seekToEnd(topicPartitions);
        consumer.assignment().forEach(arg_0 -> consumer.position(arg_0));
    }

    private static void printResults(int numMessages, double totalTime, long[] latencies) {
        System.out.printf("Avg latency: %.4f ms%n", totalTime / (double)numMessages / 1000.0 / 1000.0);
        Arrays.sort(latencies);
        int p50 = (int)latencies[(int)((double)latencies.length * 0.5)];
        int p99 = (int)latencies[(int)((double)latencies.length * 0.99)];
        int p999 = (int)latencies[(int)((double)latencies.length * 0.999)];
        System.out.printf("Percentiles: 50th = %d, 99th = %d, 99.9th = %d%n", p50, p99, p999);
    }

    private static byte[] randomBytesOfLen(Random random, int length) {
        byte[] randomBytes = new byte[length];
        Arrays.fill(randomBytes, Integer.valueOf(random.nextInt(26) + 65).byteValue());
        return randomBytes;
    }

    private static void createTopic(Optional<String> propertiesFile, String brokers, String topic) throws IOException {
        System.out.printf("Topic \"%s\" does not exist. Will create topic with %d partition(s) and replication factor = %d%n", topic, 1, (short)1);
        Properties adminProps = EndToEndLatency.loadPropsWithBootstrapServers(propertiesFile, brokers);
        Admin adminClient = Admin.create((Properties)adminProps);
        NewTopic newTopic = new NewTopic(topic, 1, 1);
        try {
            adminClient.createTopics(Collections.singleton(newTopic)).all().get();
        }
        catch (InterruptedException | ExecutionException e) {
            System.out.printf("Creation of topic %s failed%n", topic);
            throw new RuntimeException(e);
        }
        finally {
            Utils.closeQuietly((AutoCloseable)adminClient, (String)"AdminClient");
        }
    }

    private static Properties loadPropsWithBootstrapServers(Optional<String> propertiesFile, String brokers) throws IOException {
        Properties properties = propertiesFile.isPresent() ? Utils.loadProps((String)propertiesFile.get()) : new Properties();
        properties.put("bootstrap.servers", brokers);
        return properties;
    }

    private static KafkaConsumer<byte[], byte[]> createKafkaConsumer(Optional<String> propsFile, String brokers) throws IOException {
        Properties consumerProps = EndToEndLatency.loadPropsWithBootstrapServers(propsFile, brokers);
        consumerProps.put("group.id", "test-group-" + System.currentTimeMillis());
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("auto.offset.reset", "latest");
        consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("fetch.max.wait.ms", "0");
        return new KafkaConsumer(consumerProps);
    }

    private static KafkaProducer<byte[], byte[]> createKafkaProducer(Optional<String> propsFile, String brokers, String acks) throws IOException {
        Properties producerProps = EndToEndLatency.loadPropsWithBootstrapServers(propsFile, brokers);
        producerProps.put("linger.ms", "0");
        producerProps.put("max.block.ms", (Object)Long.MAX_VALUE);
        producerProps.put("acks", acks);
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        return new KafkaProducer(producerProps);
    }
}

