/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.server.group.share.DeleteShareGroupStateParameters;
import org.apache.kafka.server.group.share.DeleteShareGroupStateResult;
import org.apache.kafka.server.group.share.GroupTopicPartitionData;
import org.apache.kafka.server.group.share.InitializeShareGroupStateParameters;
import org.apache.kafka.server.group.share.InitializeShareGroupStateResult;
import org.apache.kafka.server.group.share.PartitionAllData;
import org.apache.kafka.server.group.share.PartitionErrorData;
import org.apache.kafka.server.group.share.PartitionFactory;
import org.apache.kafka.server.group.share.PartitionIdData;
import org.apache.kafka.server.group.share.PartitionIdLeaderEpochData;
import org.apache.kafka.server.group.share.PartitionStateBatchData;
import org.apache.kafka.server.group.share.PartitionStateData;
import org.apache.kafka.server.group.share.PartitionStateErrorData;
import org.apache.kafka.server.group.share.Persister;
import org.apache.kafka.server.group.share.ReadShareGroupStateParameters;
import org.apache.kafka.server.group.share.ReadShareGroupStateResult;
import org.apache.kafka.server.group.share.ReadShareGroupStateSummaryParameters;
import org.apache.kafka.server.group.share.ReadShareGroupStateSummaryResult;
import org.apache.kafka.server.group.share.TopicData;
import org.apache.kafka.server.group.share.WriteShareGroupStateParameters;
import org.apache.kafka.server.group.share.WriteShareGroupStateResult;

public class NoOpShareStatePersister
implements Persister {
    private NoOpShareStatePersister() {
    }

    public static Persister getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public CompletableFuture<InitializeShareGroupStateResult> initializeState(InitializeShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionStateData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionErrorData>> resultArgs = new ArrayList<TopicData<PartitionErrorData>>();
        for (TopicData<PartitionStateData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(partStateData -> PartitionFactory.newPartitionErrorData(partStateData.partition(), PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new InitializeShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<ReadShareGroupStateResult> readState(ReadShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionIdLeaderEpochData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionAllData>> resultArgs = new ArrayList<TopicData<PartitionAllData>>();
        for (TopicData<PartitionIdLeaderEpochData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(partitionIdData -> PartitionFactory.newPartitionAllData(partitionIdData.partition(), 0, 0L, PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new ReadShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<WriteShareGroupStateResult> writeState(WriteShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionStateBatchData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionErrorData>> resultArgs = new ArrayList<TopicData<PartitionErrorData>>();
        for (TopicData<PartitionStateBatchData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(batch -> PartitionFactory.newPartitionErrorData(batch.partition(), PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new WriteShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<DeleteShareGroupStateResult> deleteState(DeleteShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionIdData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionErrorData>> resultArgs = new ArrayList<TopicData<PartitionErrorData>>();
        for (TopicData<PartitionIdData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(batch -> PartitionFactory.newPartitionErrorData(batch.partition(), PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new DeleteShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<ReadShareGroupStateSummaryResult> readSummary(ReadShareGroupStateSummaryParameters request) {
        GroupTopicPartitionData<PartitionIdLeaderEpochData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionStateErrorData>> resultArgs = new ArrayList<TopicData<PartitionStateErrorData>>();
        for (TopicData<PartitionIdLeaderEpochData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(partitionIdData -> PartitionFactory.newPartitionStateErrorData(partitionIdData.partition(), 0, 0L, PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new ReadShareGroupStateSummaryResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public void stop() {
    }

    private static final class InstanceHolder {
        static final Persister INSTANCE = new NoOpShareStatePersister();

        private InstanceHolder() {
        }
    }
}

