/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaState$;
import kafka.log.UnifiedLog$;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\t\u0012\u0001YA\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0006\u0001BC\u0002\u0013\u0005!\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u0003,\u0011!9\u0004A!b\u0001\n\u0003A\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b\u0001\u0003A\u0011A!\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\"1\u0001\f\u0001Q\u0001\n%CQ!\u0017\u0001\u0005\u0002iCQa\u0017\u0001\u0005\u0002qCQa\u001e\u0001\u0005\u0002aDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\t9!+\u001a9mS\u000e\f'B\u0001\n\u0014\u0003\u001d\u0019G.^:uKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\u001a\u0012!B;uS2\u001c\u0018B\u0001\u0012 \u0005\u001daunZ4j]\u001e\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002KA\u0011\u0001DJ\u0005\u0003Oe\u00111!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003-\u0002\"\u0001\f\u001b\u000e\u00035R!AL\u0018\u0002\r\r|W.\\8o\u0015\t!\u0002G\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<\u0017BA\u001b.\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\n\u0002\rM,'O^3s\u0013\tq4HA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003\u0019a\u0014N\\5u}Q!!\tR#G!\t\u0019\u0005!D\u0001\u0012\u0011\u0015\u0019s\u00011\u0001&\u0011\u0015Is\u00011\u0001,\u0011\u00159t\u00011\u0001:\u00031\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f+\u0005I\u0005c\u0001&T+6\t1J\u0003\u0002M\u001b\u00061\u0011\r^8nS\u000eT!AT(\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002Q#\u0006!Q\u000f^5m\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V&\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"a\u0011,\n\u0005]\u000b\"\u0001\u0004*fa2L7-Y*uCR,\u0017!\u0004:fa2L7-Y*uCR,\u0007%A\u0007ti\u0006$Xm\u00158baNDw\u000e^\u000b\u0002+\u00069R\u000f\u001d3bi\u00164U\r^2i'R\fG/Z(s)\"\u0014xn\u001e\u000b\u0007;\u0002d\u0017o];\u0011\u0005aq\u0016BA0\u001a\u0005\u0011)f.\u001b;\t\u000b\u0005\\\u0001\u0019\u00012\u00027\u0019|G\u000e\\8xKJ4U\r^2i\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\t\u0019'.D\u0001e\u0015\t)g-A\u0002m_\u001eT!a\u001a5\u0002\u0013%tG/\u001a:oC2\u001c(BA50\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\u001b3\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rC\u0003n\u0017\u0001\u0007a.A\ng_2dwn^3s'R\f'\u000f^(gMN,G\u000f\u0005\u0002\u0019_&\u0011\u0001/\u0007\u0002\u0005\u0019>tw\rC\u0003s\u0017\u0001\u0007a.A\ng_2dwn^3s\r\u0016$8\r\u001b+j[\u0016l5\u000fC\u0003u\u0017\u0001\u0007a.A\bmK\u0006$WM]#oI>3gm]3u\u0011\u001518\u00021\u0001o\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u0002#I,7/\u001a;SKBd\u0017nY1Ti\u0006$X\r\u0006\u0004^snd\u00181\u0001\u0005\u0006u2\u0001\rA\\\u0001\u000eGV\u0014(/\u001a8u)&lW-T:\t\u000bQd\u0001\u0019\u00018\t\u000bud\u0001\u0019\u0001@\u0002\u0017%\u001ch*Z<MK\u0006$WM\u001d\t\u00031}L1!!\u0001\u001a\u0005\u001d\u0011un\u001c7fC:Da!!\u0002\r\u0001\u0004q\u0018\u0001E5t\r>dGn\\<fe&s7+\u001f8d\u0003!!xn\u0015;sS:<GCAA\u0006!\u0011\ti!a\u0007\u000f\t\u0005=\u0011q\u0003\t\u0004\u0003#IRBAA\n\u0015\r\t)\"F\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e\u0011$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033I\u0012AB3rk\u0006d7\u000fF\u0002\u007f\u0003KAq!a\n\u000f\u0001\u0004\tI#\u0001\u0003uQ\u0006$\bc\u0001\r\u0002,%\u0019\u0011QF\r\u0003\u0007\u0005s\u00170\u0001\u0005iCND7i\u001c3f)\u0005)\u0003")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final MetadataCache metadataCache;
    private final AtomicReference<ReplicaState> replicaState;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private AtomicReference<ReplicaState> replicaState() {
        return this.replicaState;
    }

    public ReplicaState stateSnapshot() {
        return this.replicaState().get();
    }

    public void updateFetchStateOrThrow(LogOffsetMetadata followerFetchOffsetMetadata, long followerStartOffset, long followerFetchTimeMs, long leaderEndOffset, long brokerEpoch) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            MetadataCache metadataCache = this.metadataCache();
            if (metadataCache instanceof KRaftMetadataCache) {
                Option<Object> cachedBrokerEpoch = ((KRaftMetadataCache)metadataCache).getAliveBrokerEpoch(this.brokerId());
                if (brokerEpoch != -1L && cachedBrokerEpoch.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 > brokerEpoch)) {
                    throw new NotLeaderOrFollowerException(new StringBuilder(61).append("Received stale fetch state update. broker epoch=").append(brokerEpoch).append(" ").append("vs expected=").append(cachedBrokerEpoch.get()).toString());
                }
            }
            long lastCaughtUpTime = followerFetchOffsetMetadata$1.messageOffset >= leaderEndOffset ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), followerFetchTimeMs) : (followerFetchOffsetMetadata$1.messageOffset >= currentReplicaState.lastFetchLeaderLogEndOffset() ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), currentReplicaState.lastFetchTimeMs()) : currentReplicaState.lastCaughtUpTimeMs());
            return new ReplicaState(followerStartOffset, followerFetchOffsetMetadata, package$.MODULE$.max(leaderEndOffset, currentReplicaState.lastFetchLeaderLogEndOffset()), followerFetchTimeMs, lastCaughtUpTime, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)brokerEpoch)));
        });
    }

    public void resetReplicaState(long currentTimeMs, long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTimeMs;
            long l = lastCaughtUpTimeMs = isFollowerInSync ? currentTimeMs : 0L;
            if (isNewLeader) {
                return new ReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, UnifiedLog$.MODULE$.UnknownOffset(), 0L, lastCaughtUpTimeMs, (Option<Object>)Option$.MODULE$.empty());
            }
            return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, isFollowerInSync ? currentTimeMs : 0L, lastCaughtUpTimeMs, currentReplicaState.brokerEpoch());
        });
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Reset state of replica to ").append(this).toString());
    }

    public String toString() {
        ReplicaState replicaState = this.replicaState().get();
        scala.collection.mutable.StringBuilder replicaString = new scala.collection.mutable.StringBuilder();
        replicaString.append(new StringBuilder(18).append("Replica(replicaId=").append(this.brokerId()).toString());
        replicaString.append(new StringBuilder(8).append(", topic=").append(this.topicPartition().topic()).toString());
        replicaString.append(new StringBuilder(12).append(", partition=").append(this.topicPartition().partition()).toString());
        replicaString.append(new StringBuilder(21).append(", lastCaughtUpTimeMs=").append(replicaState.lastCaughtUpTimeMs()).toString());
        replicaString.append(new StringBuilder(17).append(", logStartOffset=").append(replicaState.logStartOffset()).toString());
        replicaString.append(new StringBuilder(15).append(", logEndOffset=").append(replicaState.logEndOffsetMetadata().messageOffset).toString());
        replicaString.append(new StringBuilder(23).append(", logEndOffsetMetadata=").append(replicaState.logEndOffsetMetadata()).toString());
        replicaString.append(new StringBuilder(30).append(", lastFetchLeaderLogEndOffset=").append(replicaState.lastFetchLeaderLogEndOffset()).toString());
        replicaString.append(new StringBuilder(14).append(", brokerEpoch=").append(replicaState.brokerEpoch().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -2L)).toString());
        replicaString.append(new StringBuilder(18).append(", lastFetchTimeMs=").append(replicaState.lastFetchTimeMs()).toString());
        replicaString.append(")");
        return replicaString.toString();
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica replica = (Replica)that;
            if (this.brokerId() == replica.brokerId()) {
                TopicPartition topicPartition = this.topicPartition();
                TopicPartition topicPartition2 = replica.topicPartition();
                if (!(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public Replica(int brokerId, TopicPartition topicPartition, MetadataCache metadataCache) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.metadataCache = metadataCache;
        this.replicaState = new AtomicReference<ReplicaState>(ReplicaState$.MODULE$.Empty());
    }
}

