/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.governance.common.constant.job

object JobRequestConstants {

  val JOB_ID = "jobId"

  val JOB_HISTORY_LIST = "jobHistoryList"

  val JOB_REQUEST_LIST = "jobRequestList"

  val TOTAL_PAGE = "totalPage"

  val JOB_DETAIL_LIST = "jobDetailList"

  val JOB_SOURCE_TAGS = "job.source.tags"

  val LINKIS_JDBC_DEFAULT_DB = "linkis.jdbc.default.db"

  val ENABLE_DIRECT_PUSH = "enableDirectPush"

  val DIRECT_PUSH_FETCH_SIZE = "direct_push_fetch_size"
}
