/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.plugins;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggerRepository;

public abstract class PluginSkeleton
extends ComponentBase
implements Plugin {
    protected String name = "plugin";
    protected boolean active;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    protected PluginSkeleton() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.propertySupport.firePropertyChange("name", oldName, this.name);
    }

    @Override
    public LoggerRepository getLoggerRepository() {
        return this.repository;
    }

    @Override
    public void setLoggerRepository(LoggerRepository repository) {
        LoggerRepository oldValue = this.repository;
        this.repository = repository;
        this.firePropertyChange("loggerRepository", oldValue, this.repository);
    }

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isEquivalent(Plugin testPlugin) {
        return this.repository == testPlugin.getLoggerRepository() && (this.name == null && testPlugin.getName() == null || this.name != null && this.name.equals(testPlugin.getName())) && this.getClass().equals(testPlugin.getClass());
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    @Override
    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    protected final void firePropertyChange(PropertyChangeEvent evt) {
        this.propertySupport.firePropertyChange(evt);
    }

    protected final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

