/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.maven;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.generator.DocumentationGenerator;
import org.apache.logging.log4j.docgen.generator.DocumentationGeneratorArgs;
import org.apache.logging.log4j.docgen.generator.DocumentationTemplate;
import org.apache.logging.log4j.docgen.maven.AbstractDocgenMojo;
import org.apache.logging.log4j.docgen.maven.DocumentationTemplateMojo;
import org.apache.logging.log4j.docgen.maven.PluginSets;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-documentation", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class DocumentationGeneratorMojo
extends AbstractDocgenMojo {
    @Parameter(property="log4j.docgen.templateDirectory", required=true)
    private File templateDirectory;
    @Parameter
    private DocumentationTemplateMojo[] indexTemplates;
    @Parameter
    private DocumentationTemplateMojo[] typeTemplates;

    public void execute() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping documentation generation");
            return;
        }
        Set<PluginSet> pluginSets = PluginSets.ofDescriptorFilesAndFileMatchers(this.descriptorFiles, this.descriptorFileMatchers);
        Predicate<String> classNameFilter = this.typeFilter != null ? this.typeFilter.createPredicate() : ignored -> true;
        DocumentationGeneratorArgs generatorArgs = new DocumentationGeneratorArgs(pluginSets, classNameFilter, this.templateDirectory.toPath(), DocumentationGeneratorMojo.toApiModel(this.indexTemplates), DocumentationGeneratorMojo.toApiModel(this.typeTemplates));
        DocumentationGenerator.generateDocumentation((DocumentationGeneratorArgs)generatorArgs);
    }

    private static Set<DocumentationTemplate> toApiModel(DocumentationTemplateMojo[] mojos) {
        return Arrays.stream(mojos).map(mojo -> new DocumentationTemplate(mojo.source, mojo.target)).collect(Collectors.toSet());
    }
}

