/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMultiset;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.EnumMultiset$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.EnumMultiset$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multisets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.ObjIntConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EnumMultiset
extends AbstractMultiset
implements Serializable {
    private transient Class type;
    private transient Enum[] enumConstants;
    private transient int[] counts;
    private transient int distinctElements;
    private transient long size;

    private boolean isActuallyE(@Nullable Object object) {
        if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            int n = enum_.ordinal();
            return n < this.enumConstants.length && this.enumConstants[n] == enum_;
        }
        return false;
    }

    void checkIsE(@Nullable Object object) {
        Preconditions.checkNotNull(object);
        if (!this.isActuallyE(object)) {
            throw new ClassCastException("Expected an " + this.type + " but got " + object);
        }
    }

    @Override
    int distinctElements() {
        return this.distinctElements;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public int count(@Nullable Object object) {
        if (object == null || !this.isActuallyE(object)) {
            return 0;
        }
        Enum enum_ = (Enum)object;
        return this.counts[enum_.ordinal()];
    }

    @CanIgnoreReturnValue
    public int add(Enum enum_, int n) {
        this.checkIsE(enum_);
        CollectPreconditions.checkNonnegative(n, "occurrences");
        if (n == 0) {
            return this.count(enum_);
        }
        int n2 = enum_.ordinal();
        int n3 = this.counts[n2];
        long l = (long)n3 + (long)n;
        Preconditions.checkArgument(l <= Integer.MAX_VALUE, "too many occurrences: %s", l);
        this.counts[n2] = (int)l;
        if (n3 == 0) {
            ++this.distinctElements;
        }
        this.size += (long)n;
        return n3;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@Nullable Object object, int n) {
        if (object == null || !this.isActuallyE(object)) {
            return 0;
        }
        Enum enum_ = (Enum)object;
        CollectPreconditions.checkNonnegative(n, "occurrences");
        if (n == 0) {
            return this.count(object);
        }
        int n2 = enum_.ordinal();
        int n3 = this.counts[n2];
        if (n3 == 0) {
            return 0;
        }
        if (n3 <= n) {
            this.counts[n2] = 0;
            --this.distinctElements;
            this.size -= (long)n3;
        } else {
            this.counts[n2] = n3 - n;
            this.size -= (long)n;
        }
        return n3;
    }

    @CanIgnoreReturnValue
    public int setCount(Enum enum_, int n) {
        this.checkIsE(enum_);
        CollectPreconditions.checkNonnegative(n, "count");
        int n2 = enum_.ordinal();
        int n3 = this.counts[n2];
        this.counts[n2] = n;
        this.size += (long)(n - n3);
        if (n3 == 0 && n > 0) {
            ++this.distinctElements;
        } else if (n3 > 0 && n == 0) {
            --this.distinctElements;
        }
        return n3;
    }

    @Override
    public void clear() {
        Arrays.fill(this.counts, 0);
        this.size = 0L;
        this.distinctElements = 0;
    }

    @Override
    Iterator elementIterator() {
        return new EnumMultiset$1(this);
    }

    @Override
    Iterator entryIterator() {
        return new EnumMultiset$2(this);
    }

    @Override
    public void forEachEntry(ObjIntConsumer objIntConsumer) {
        Preconditions.checkNotNull(objIntConsumer);
        for (int i = 0; i < this.enumConstants.length; ++i) {
            if (this.counts[i] <= 0) continue;
            objIntConsumer.accept(this.enumConstants[i], this.counts[i]);
        }
    }

    @Override
    public Iterator iterator() {
        return Multisets.iteratorImpl(this);
    }

    static /* synthetic */ Enum[] access$000(EnumMultiset enumMultiset) {
        return enumMultiset.enumConstants;
    }

    static /* synthetic */ int[] access$100(EnumMultiset enumMultiset) {
        return enumMultiset.counts;
    }

    static /* synthetic */ int access$210(EnumMultiset enumMultiset) {
        return enumMultiset.distinctElements--;
    }

    static /* synthetic */ long access$300(EnumMultiset enumMultiset) {
        return enumMultiset.size;
    }

    static /* synthetic */ long access$302(EnumMultiset enumMultiset, long l) {
        enumMultiset.size = l;
        return enumMultiset.size;
    }
}

