/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectSpliterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$ReverseImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$SubList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SingletonImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableListIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ImmutableList
extends ImmutableCollection
implements List,
RandomAccess {
    public static ImmutableList of() {
        return RegularImmutableList.EMPTY;
    }

    public static ImmutableList of(Object object) {
        return new SingletonImmutableList(object);
    }

    public static ImmutableList copyOf(Collection collection) {
        if (collection instanceof ImmutableCollection) {
            ImmutableList immutableList = ((ImmutableCollection)collection).asList();
            return immutableList.isPartialView() ? ImmutableList.asImmutableList(immutableList.toArray()) : immutableList;
        }
        return ImmutableList.construct(collection.toArray());
    }

    public static ImmutableList copyOf(Object[] objectArray) {
        switch (objectArray.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(objectArray[0]);
            }
        }
        return ImmutableList.construct((Object[])objectArray.clone());
    }

    public static ImmutableList sortedCopyOf(Comparator comparator, Iterable iterable) {
        Preconditions.checkNotNull(comparator);
        Object[] objectArray = Iterables.toArray(iterable);
        ObjectArrays.checkElementsNotNull(objectArray);
        Arrays.sort(objectArray, comparator);
        return ImmutableList.asImmutableList(objectArray);
    }

    private static ImmutableList construct(Object ... objectArray) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    static ImmutableList asImmutableList(Object[] objectArray) {
        return ImmutableList.asImmutableList(objectArray, objectArray.length);
    }

    static ImmutableList asImmutableList(Object[] objectArray, int n) {
        switch (n) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(objectArray[0]);
            }
        }
        if (n < objectArray.length) {
            objectArray = Arrays.copyOf(objectArray, n);
        }
        return new RegularImmutableList(objectArray);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator iterator() {
        return this.listIterator();
    }

    public UnmodifiableListIterator listIterator() {
        return this.listIterator(0);
    }

    public UnmodifiableListIterator listIterator(int n) {
        return new ImmutableList$1(this, this.size(), n);
    }

    @Override
    public void forEach(Consumer consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.indexOfImpl(this, object);
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.lastIndexOfImpl(this, object);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) >= 0;
    }

    public ImmutableList subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size());
        int n3 = n2 - n;
        if (n3 == this.size()) {
            return this;
        }
        if (n3 == 0) {
            return ImmutableList.of();
        }
        if (n3 == 1) {
            return ImmutableList.of(this.get(n));
        }
        return this.subListUnchecked(n, n2);
    }

    ImmutableList subListUnchecked(int n, int n2) {
        return new ImmutableList$SubList(this, n, n2 - n);
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void replaceAll(UnaryOperator unaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void sort(Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList asList() {
        return this;
    }

    @Override
    public Spliterator spliterator() {
        return CollectSpliterators.indexed(this.size(), 1296, this::get);
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            objectArray[n + i] = this.get(i);
        }
        return n + n2;
    }

    public ImmutableList reverse() {
        return this.size() <= 1 ? this : new ImmutableList$ReverseImmutableList(this);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        int n = 1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + this.get(i).hashCode();
            n = ~(~n);
        }
        return n;
    }

    public static ImmutableList$Builder builder() {
        return new ImmutableList$Builder();
    }
}

