/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.ArrayList;
import java.util.Iterator;
import org.exolab.castor.jdo.oql.Token;

public final class ParseTreeNode {
    private static final NullIterator NULL_ITERATOR = new NullIterator();
    private ParseTreeNode _parent;
    private ArrayList _children;
    private Token _token;

    public ParseTreeNode(ParseTreeNode parent, Token token) {
        this._parent = parent;
        this._token = token;
    }

    public ParseTreeNode(Token token) {
        this._parent = null;
        this._token = token;
    }

    public String toString() {
        return "ParseTreeNode{" + this._token.getTokenValue() + "}";
    }

    public String toStringEx() {
        StringBuffer s = new StringBuffer("ParseTreeNode{");
        s.append(this._token.getTokenValue());
        Iterator iter = this.children();
        while (iter.hasNext()) {
            s.append(',');
            s.append(((ParseTreeNode)iter.next()).toStringEx());
        }
        s.append('}');
        return s.toString();
    }

    public void setParent(ParseTreeNode parent) {
        this._parent = parent;
    }

    public void addChild(ParseTreeNode child) {
        child.setParent(this);
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(child);
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public boolean isLeaf() {
        return this._children == null || this._children.size() == 0;
    }

    public ParseTreeNode getParent() {
        return this._parent;
    }

    public Iterator children() {
        if (this._children == null || this._children.size() == 0) {
            return NULL_ITERATOR;
        }
        return this._children.iterator();
    }

    public ParseTreeNode getChild(int index) {
        return (ParseTreeNode)this._children.get(index);
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public Token getToken() {
        return this._token;
    }

    private static final class NullIterator
    implements Iterator {
        private NullIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

