/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTransferEncodingField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.message.HeaderImpl;

public abstract class AbstractEntity
implements Entity {
    private Header header = null;
    private Body body = null;
    private Entity parent = null;

    protected AbstractEntity() {
    }

    @Override
    public Entity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Entity parent) {
        this.parent = parent;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public void setBody(Body body) {
        if (this.body != null) {
            throw new IllegalStateException("body already set");
        }
        this.body = body;
        body.setParent(this);
    }

    @Override
    public Body removeBody() {
        if (this.body == null) {
            return null;
        }
        Body body = this.body;
        this.body = null;
        body.setParent(null);
        return body;
    }

    @Override
    public String getMimeType() {
        ContentTypeField childType = this.getContentTypeField();
        Entity parent = this.getParent();
        ContentTypeField parentType = parent != null ? (ContentTypeField)parent.getHeader().getField("Content-Type") : null;
        return this.calcMimeType(childType, parentType);
    }

    private ContentTypeField getContentTypeField() {
        return (ContentTypeField)this.getHeader().getField("Content-Type");
    }

    @Override
    public String getCharset() {
        return this.calcCharset((ContentTypeField)this.getHeader().getField("Content-Type"));
    }

    @Override
    public String getContentTransferEncoding() {
        ContentTransferEncodingField f = (ContentTransferEncodingField)this.getHeader().getField("Content-Transfer-Encoding");
        return this.calcTransferEncoding(f);
    }

    @Override
    public String getDispositionType() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        if (field == null) {
            return null;
        }
        return field.getDispositionType();
    }

    @Override
    public String getFilename() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        if (field == null) {
            return null;
        }
        return field.getFilename();
    }

    @Override
    public boolean isMultipart() {
        ContentTypeField f = this.getContentTypeField();
        return f != null && f.getBoundary() != null && this.getMimeType().startsWith("multipart/");
    }

    @Override
    public void dispose() {
        if (this.body != null) {
            this.body.dispose();
        }
    }

    Header obtainHeader() {
        if (this.header == null) {
            this.header = new HeaderImpl();
        }
        return this.header;
    }

    <F extends ParsedField> F obtainField(String fieldName) {
        Header header = this.getHeader();
        if (header == null) {
            return null;
        }
        return (F)((ParsedField)header.getField(fieldName));
    }

    protected abstract String calcMimeType(ContentTypeField var1, ContentTypeField var2);

    protected abstract String calcTransferEncoding(ContentTransferEncodingField var1);

    protected abstract String calcCharset(ContentTypeField var1);
}

