/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.sis.internal.util.Numerics;

public final class AutoMessageFormat
extends MessageFormat {
    private transient NumberFormat[] formatsToConfigure;
    private transient boolean update;

    public AutoMessageFormat(String string) {
        super(string);
    }

    public AutoMessageFormat(String string, Locale locale) {
        super(string, locale);
    }

    @Override
    public void applyPattern(String string) {
        super.applyPattern(string);
        this.update = true;
    }

    public void configure(Object[] objectArray) {
        Object object;
        if (this.update) {
            this.formatsToConfigure = null;
            Format[] formatArray = this.getFormatsByArgumentIndex();
            int n = formatArray.length;
            while (--n >= 0) {
                object = formatArray[n];
                if (!(object instanceof NumberFormat)) continue;
                if (this.formatsToConfigure == null) {
                    this.formatsToConfigure = new NumberFormat[n + 1];
                }
                this.formatsToConfigure[n] = (NumberFormat)object;
            }
        }
        if (this.formatsToConfigure != null) {
            int n = Math.min(this.formatsToConfigure.length, objectArray.length);
            while (--n >= 0) {
                double d;
                NumberFormat numberFormat = this.formatsToConfigure[n];
                if (numberFormat == null) continue;
                object = objectArray[n];
                int n2 = 3;
                if (object instanceof Number && !Double.isNaN(d = ((Number)object).doubleValue())) {
                    n2 = -1 - Numerics.toExp10(Math.getExponent(Math.ulp(d)));
                }
                numberFormat.setMaximumFractionDigits(Math.min(n2, 16));
            }
        }
    }
}

