/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter.ruletree;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.internal.impl.filter.ruletree.Node;

public class PrefixTree
extends Node {
    public static final PrefixTree SENTINEL = new PrefixTree("sentinel");

    private static List<String> elementsOfPath(String path) {
        return Arrays.stream(path.split("/")).filter(e -> !e.isEmpty()).collect(Collectors.toList());
    }

    public PrefixTree(String name) {
        super(name, false, null);
    }

    public int loadNodes(Stream<String> linesStream) {
        AtomicInteger counter = new AtomicInteger(0);
        linesStream.forEach(line -> {
            if (this.loadNode((String)line)) {
                counter.incrementAndGet();
            }
        });
        return counter.get();
    }

    public boolean loadNode(String line) {
        if (!line.startsWith("#") && !line.trim().isEmpty()) {
            Node currentNode = this;
            for (String element : PrefixTree.elementsOfPath(line)) {
                currentNode = currentNode.addSibling(element, false, null);
            }
            return true;
        }
        return false;
    }

    public boolean acceptedPath(String path) {
        String pathElement;
        List<String> pathElements = PrefixTree.elementsOfPath(path);
        Node currentNode = this;
        Iterator<String> iterator = pathElements.iterator();
        while (iterator.hasNext() && (currentNode = currentNode.getSibling(pathElement = iterator.next())) != null && !currentNode.isLeaf()) {
        }
        return currentNode != null && currentNode.isLeaf();
    }
}

