/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.util.Convert;

public class Constants {
    public static Object decode(Object value, Type type) {
        Object object = value;
        if (object instanceof Integer) {
            Integer intVal = (Integer)object;
            int i = intVal;
            switch (type.getTag()) {
                case BOOLEAN: {
                    return i != 0;
                }
                case CHAR: {
                    return Character.valueOf((char)i);
                }
                case BYTE: {
                    return (byte)i;
                }
                case SHORT: {
                    return (short)i;
                }
            }
        }
        return value;
    }

    public static String format(Object value, Type type) {
        value = Constants.decode(value, type);
        switch (type.getTag()) {
            case BYTE: {
                return Constants.formatByte((Byte)value);
            }
            case LONG: {
                return Constants.formatLong((Long)value);
            }
            case FLOAT: {
                return Constants.formatFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Constants.formatDouble((Double)value);
            }
            case CHAR: {
                return Constants.formatChar(((Character)value).charValue());
            }
        }
        Object object = value;
        if (object instanceof String) {
            String str = (String)object;
            return Constants.formatString(str);
        }
        return value + "";
    }

    public static String format(Object value) {
        Object object = value;
        if (object instanceof Byte) {
            Byte byteVal = (Byte)object;
            return Constants.formatByte(byteVal);
        }
        object = value;
        if (object instanceof Short) {
            Short shortVal = (Short)object;
            return Constants.formatShort(shortVal);
        }
        object = value;
        if (object instanceof Long) {
            Long longVal = (Long)object;
            return Constants.formatLong(longVal);
        }
        object = value;
        if (object instanceof Float) {
            Float floatVal = (Float)object;
            return Constants.formatFloat(floatVal.floatValue());
        }
        object = value;
        if (object instanceof Double) {
            Double doubleVal = (Double)object;
            return Constants.formatDouble(doubleVal);
        }
        object = value;
        if (object instanceof Character) {
            Character charVal = (Character)object;
            return Constants.formatChar(charVal.charValue());
        }
        object = value;
        if (object instanceof String) {
            String strVal = (String)object;
            return Constants.formatString(strVal);
        }
        if (value instanceof Integer || value instanceof Boolean) {
            return value.toString();
        }
        throw new IllegalArgumentException("Argument is not a primitive type or a string; it " + (value == null ? "is a null value." : "has class " + value.getClass().getName()) + ".");
    }

    private static String formatByte(byte b) {
        return String.format("(byte)0x%02x", b);
    }

    private static String formatShort(short s) {
        return String.format("(short)%d", s);
    }

    private static String formatLong(long lng) {
        return lng + "L";
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return f + "f";
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return d + "";
    }

    private static String formatChar(char c) {
        return '\'' + Convert.quote(c) + '\'';
    }

    private static String formatString(String s) {
        return '\"' + Convert.quote(s) + '\"';
    }
}

