/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationAction;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToSuperTypeAction
extends BaseAction {
    public GoToSuperTypeAction() {
        super("goto-super-implementation", 132);
        this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("goto-super-implementation"));
        String name = NbBundle.getBundle(JavaKit.class).getString("goto-super-implementation-trimmed");
        this.putValue("trimmed-text", name);
        this.putValue("PopupMenuText", name);
    }

    @Override
    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        final JavaSource js = JavaSource.forDocument(target.getDocument());
        if (js == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToSupport.class, "WARN_CannotGoToGeneric", 1));
            return;
        }
        final int caretPos = target.getCaretPosition();
        final AtomicBoolean cancel = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                GoToSuperTypeAction.goToImpl(target, js, caretPos, cancel);
            }
        }, NbBundle.getMessage(JavaKit.class, "goto-super-implementation"), cancel, false);
    }

    private static void goToImpl(final JTextComponent c, JavaSource js, final int caretPos, final AtomicBoolean cancel) {
        try {
            js.runUserActionTask(new Task<CompilationController>(){

                @Override
                public void run(CompilationController parameter) throws Exception {
                    if (cancel != null && cancel.get()) {
                        return;
                    }
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    ExecutableElement ee = GoToSuperTypeAction.resolveMethodElement(parameter, caretPos);
                    if (ee == null) {
                        ee = GoToSuperTypeAction.resolveMethodElement(parameter, caretPos + 1);
                    }
                    if (ee == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    final ArrayList<ElementDescription> result = new ArrayList<ElementDescription>();
                    final AnnotationType type = ComputeOverriding.detectOverrides(parameter, (TypeElement)ee.getEnclosingElement(), ee, result);
                    if (type == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Point p = c.modelToView(c.getCaretPosition()).getLocation();
                                IsOverriddenAnnotationAction.mouseClicked(Collections.singletonMap(IsOverriddenAnnotationAction.computeCaption(type, ""), result), c, p);
                            }
                            catch (BadLocationException e) {
                                Exceptions.printStackTrace(e);
                            }
                        }
                    });
                }
            }, true);
        }
        catch (IOException e) {
            Exceptions.printStackTrace(e);
        }
    }

    private static ExecutableElement resolveMethodElement(CompilationInfo info, int caret) {
        TreePath path;
        for (path = info.getTreeUtilities().pathFor(caret); path != null && path.getLeaf().getKind() != Tree.Kind.METHOD; path = path.getParentPath()) {
        }
        if (path == null) {
            return null;
        }
        Element resolved = info.getTrees().getElement(path);
        if (resolved == null || resolved.getKind() != ElementKind.METHOD) {
            return null;
        }
        return (ExecutableElement)resolved;
    }
}

