/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.List;
import javax.swing.SwingUtilities;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt.sun.tools.javac.tree.JCTree;
import jpt30.lang.model.element.Name;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.jdk.CheckRegexTopComponent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class CheckRegex {
    @CheckForNull
    public static ErrorDescription computeWarning(HintContext ctx) {
        String originalString = null;
        Tree leaf = ctx.getVariables().get("$pattern").getLeaf();
        if (leaf.getKind() == Tree.Kind.STRING_LITERAL) {
            originalString = (String)((LiteralTree)leaf).getValue();
        } else if (leaf.getKind() == Tree.Kind.IDENTIFIER) {
            originalString = CheckRegex.identifierSearch(leaf, ctx);
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_CheckRegex(), new FixImpl(ctx.getInfo(), ctx.getPath(), originalString).toEditorFix());
    }

    @CheckForNull
    public static String identifierSearch(Tree leaf, HintContext ctx) {
        TreePath tp;
        String originalString = null;
        Name name = ((IdentifierTree)leaf).getName();
        Tree statement = tp.getLeaf();
        BlockTree bt = null;
        for (tp = ctx.getPath().getParentPath(); originalString == null && tp != null; tp = tp.getParentPath()) {
            if (tp.getLeaf() instanceof JCTree.JCBlock) {
                originalString = CheckRegex.identifierBlockSearch(tp.getLeaf(), name, statement, bt);
                bt = (BlockTree)tp.getLeaf();
                continue;
            }
            if (!(tp.getLeaf() instanceof JCTree.JCClassDecl)) continue;
            originalString = CheckRegex.identifierClassSearch(tp.getLeaf(), name);
        }
        return originalString;
    }

    @CheckForNull
    private static String identifierBlockSearch(Tree leaf, Name name, Tree statement, BlockTree blocktree) {
        String res = null;
        try {
            BlockTree bt = (BlockTree)leaf;
            List<? extends StatementTree> statements = bt.getStatements();
            for (int i = 0; i < statements.size(); ++i) {
                AssignmentTree at;
                ExpressionStatementTree est;
                ExpressionTree et;
                StatementTree st = statements.get(i);
                if (st.equals(statement)) {
                    return res;
                }
                if (st.equals(blocktree)) {
                    return res;
                }
                if (st instanceof VariableTree) {
                    VariableTree vt = (VariableTree)st;
                    if (!vt.getType().toString().equalsIgnoreCase("String") || !vt.getName().equals(name)) continue;
                    LiteralTree lt = (LiteralTree)vt.getInitializer();
                    res = (String)lt.getValue();
                    continue;
                }
                if (!(st instanceof ExpressionStatementTree) || !((et = (est = (ExpressionStatementTree)st).getExpression()) instanceof AssignmentTree) || !(at = (AssignmentTree)et).getVariable().toString().equals(name.toString())) continue;
                res = (String)((LiteralTree)((AssignmentTree)est.getExpression()).getExpression()).getValue();
            }
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    @CheckForNull
    private static String identifierClassSearch(Tree leaf, Name name) {
        String res = null;
        try {
            ClassTree ct = (ClassTree)leaf;
            List<? extends Tree> members = ct.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                AssignmentTree at;
                ExpressionStatementTree est;
                ExpressionTree et;
                Tree t = members.get(i);
                if (t instanceof VariableTree) {
                    VariableTree vt = (VariableTree)t;
                    if (!vt.getType().toString().equalsIgnoreCase("String") || !vt.getName().equals(name)) continue;
                    LiteralTree lt = (LiteralTree)vt.getInitializer();
                    res = lt != null ? (String)lt.getValue() : null;
                    continue;
                }
                if (!(t instanceof ExpressionStatementTree) || !((et = (est = (ExpressionStatementTree)t).getExpression()) instanceof AssignmentTree) || !(at = (AssignmentTree)et).getVariable().toString().equals(name.toString())) continue;
                res = (String)((LiteralTree)((AssignmentTree)est.getExpression()).getExpression()).getValue();
            }
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    private static final class FixImpl
    extends JavaFix {
        private final String origString;

        private FixImpl(CompilationInfo info, TreePath path, String origString) {
            super(info, path);
            this.origString = origString;
        }

        @Override
        protected String getText() {
            return Bundle.DESC_CheckRegex();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext tc) throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckRegexTopComponent win = CheckRegexTopComponent.findInstance();
                    win.open();
                    win.requestActive();
                    win.setData(origString);
                }
            });
        }
    }
}

