/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.java.hints.ui.InnerPanelSupport;
import org.netbeans.modules.java.hints.ui.TypeAcceptor;
import org.netbeans.modules.java.source.parsing.ClasspathInfoTask;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ClassNameList
extends JPanel
implements Runnable {
    private ClasspathInfo classpathInfo;
    private boolean ordered;
    private DefaultTableModel model;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean suppressEvents;
    private TypeAcceptor<ElementHandle<TypeElement>, CompilationController> typeAcceptor = new TypeAcceptor<ElementHandle<TypeElement>, CompilationController>(){

        @Override
        public boolean accept(ElementHandle<TypeElement> item, CompilationController context) {
            return true;
        }
    };
    private CompilationController controller;
    private TypeElementFinder.Customizer customizer = new TypeElementFinder.Customizer(){

        @Override
        public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
            return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
        }

        @Override
        public boolean accept(ElementHandle<TypeElement> typeHandle) {
            return ClassNameList.this.typeAcceptor.accept(typeHandle, ClassNameList.this.controller);
        }
    };
    private JButton btnAdd;
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private JScrollPane jScrollPane2;
    private JTable listClasses;

    public ClassNameList onClassPath(ClasspathInfo cpInfo) {
        this.classpathInfo = cpInfo;
        return this;
    }

    public ClassNameList restrictTypes(TypeAcceptor<ElementHandle<TypeElement>, CompilationController> acceptor) {
        this.typeAcceptor = acceptor;
        return this;
    }

    public ClassNameList setOrdered(boolean ordered) {
        this.ordered = ordered;
        this.updateButtons();
        return this;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateButtons();
    }

    public ClassNameList() {
        this.initComponents();
        this.listClasses.setTableHeader(null);
        this.listClasses.getColumnModel().getColumn(0).setCellRenderer(new EnableAwareRenderer());
        this.listClasses.getColumnModel().getColumn(0).setCellEditor(new ValidatingCellEditor());
        this.listClasses.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClassNameList.this.updateButtons();
            }
        });
        InnerPanelSupport.displayExtendedCells(this.listClasses);
    }

    @Override
    public void run() {
        this.updateButtons();
    }

    private void updateButtons() {
        boolean selected = !this.listClasses.getSelectionModel().isSelectionEmpty();
        this.btnRemove.setEnabled(selected);
        if (this.ordered) {
            this.btnUp.setEnabled(selected);
            this.btnDown.setEnabled(selected);
        } else {
            this.btnUp.setVisible(false);
            this.btnDown.setVisible(false);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireStateChange() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        ArrayList<ChangeListener> toCall = new ArrayList<ChangeListener>(this.listeners);
        for (ChangeListener cl : toCall) {
            cl.stateChanged(e);
        }
    }

    public List<String> getClassNames() {
        int s = this.model.getRowCount();
        ArrayList<String> res = new ArrayList<String>(s);
        for (int i = 0; i < s; ++i) {
            res.add((String)this.model.getValueAt(i, 0));
        }
        return res;
    }

    public String getClassNameList() {
        List<String> types = this.getClassNames();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : types) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(s);
        }
        return sb.toString();
    }

    public void setClassNames(String classNameList) {
        StringTokenizer tukac = new StringTokenizer(classNameList, ", ", false);
        ArrayList<String> res = new ArrayList<String>(3);
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if (token.isEmpty()) continue;
            res.add(token);
        }
        this.setClassNames(res);
    }

    public void setClassNames(List<String> names) {
        DefaultTableModel mdl = new DefaultTableModel(0, 1);
        for (String s : names) {
            mdl.addRow(new Object[]{s});
        }
        this.listClasses.setModel(mdl);
        this.listClasses.getColumnModel().getColumn(0).setCellRenderer(new EnableAwareRenderer());
        this.listClasses.getColumnModel().getColumn(0).setCellEditor(new ValidatingCellEditor());
        this.model = mdl;
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.listClasses = new ExTable();
        Mnemonics.setLocalizedText(this.btnAdd, NbBundle.getMessage(ClassNameList.class, "ClassNameList.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassNameList.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.btnRemove, NbBundle.getMessage(ClassNameList.class, "ClassNameList.btnRemove.text"));
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassNameList.this.btnRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.btnUp, NbBundle.getMessage(ClassNameList.class, "ClassNameList.btnUp.text"));
        this.btnUp.setEnabled(false);
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassNameList.this.btnUpActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.btnDown, NbBundle.getMessage(ClassNameList.class, "ClassNameList.btnDown.text"));
        this.btnDown.setEnabled(false);
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassNameList.this.btnDownActionPerformed(evt);
            }
        });
        this.listClasses.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.listClasses.setFillsViewportHeight(true);
        this.listClasses.setSelectionMode(2);
        this.listClasses.setShowVerticalLines(false);
        this.jScrollPane2.setViewportView(this.listClasses);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 383, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnDown, -1, -1, Short.MAX_VALUE).addComponent(this.btnAdd, -1, -1, Short.MAX_VALUE).addComponent(this.btnUp, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemove, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE))).addContainerGap()));
    }

    private int[] getSelectedIndices() {
        ListSelectionModel mdl = this.listClasses.getSelectionModel();
        int min = mdl.getMinSelectionIndex();
        int max = mdl.getMaxSelectionIndex();
        int[] indices = new int[max - min + 1];
        int ix = 0;
        for (int i = mdl.getMinSelectionIndex(); i <= max; ++i) {
            if (!mdl.isSelectedIndex(i)) continue;
            indices[ix++] = i;
        }
        int[] result = new int[ix];
        System.arraycopy(indices, 0, result, 0, ix);
        return result;
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int[] selected = this.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        this.suppressEvents = true;
        for (int ind : selected) {
            this.model.removeRow(ind);
        }
        this.suppressEvents = false;
        this.fireStateChange();
    }

    private void btnUpActionPerformed(ActionEvent evt) {
        int[] selected = this.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        this.suppressEvents = true;
        for (int ind : selected) {
            if (ind == 0) continue;
            String item = (String)this.model.getValueAt(ind, 0);
            this.model.removeRow(ind);
            this.model.insertRow(ind - 1, new Object[]{item});
            this.listClasses.getSelectionModel().addSelectionInterval(ind - 1, ind - 1);
        }
        this.suppressEvents = false;
        this.fireStateChange();
    }

    private void btnDownActionPerformed(ActionEvent evt) {
        int[] selected = this.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        this.suppressEvents = true;
        for (int i = selected.length - 1; i >= 0; --i) {
            int ind = selected[i];
            if (ind >= this.model.getRowCount() - 1) continue;
            String item = (String)this.model.getValueAt(ind, 0);
            this.model.removeRow(ind);
            this.model.insertRow(ind + 1, new Object[]{item});
            this.listClasses.getSelectionModel().addSelectionInterval(ind + 1, ind + 1);
        }
        this.suppressEvents = false;
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void btnAddActionPerformed(ActionEvent evt) {
        if (this.classpathInfo == null) {
            HashSet<ClassPath> cpPaths = new HashSet<ClassPath>(GlobalPathRegistry.getDefault().getPaths("classpath/compile"));
            HashSet<ClassPath> bootPaths = new HashSet<ClassPath>(GlobalPathRegistry.getDefault().getPaths("classpath/boot"));
            Set<ClassPath> sourcePaths = GlobalPathRegistry.getDefault().getPaths("classpath/source");
            JavaPlatform p = JavaPlatform.getDefault();
            if (p != null) {
                bootPaths.add(p.getBootstrapLibraries());
                cpPaths.add(p.getStandardLibraries());
            }
            ClassPath compPath = ClassPathSupport.createProxyClassPath(cpPaths.toArray(new ClassPath[cpPaths.size()]));
            ClassPath bootPath = ClassPathSupport.createProxyClassPath(bootPaths.toArray(new ClassPath[bootPaths.size()]));
            ClassPath sourcePath = ClassPathSupport.createProxyClassPath(sourcePaths.toArray(new ClassPath[sourcePaths.size()]));
            this.classpathInfo = ClasspathInfo.create(bootPath, compPath, sourcePath);
        }
        try {
            ParserManager.parse("text/x-java", (UserTask)new ClasspathInfoTask(this.classpathInfo){

                @Override
                public void run(ResultIterator resultIterator) throws Exception {
                    if (ClassNameList.this.controller != null) {
                        return;
                    }
                    Parser.Result res = resultIterator.getParserResult();
                    CompilationController ctrl = CompilationController.get(res);
                    if (ctrl != null) {
                        ClassNameList.this.controller = ctrl;
                        return;
                    }
                    for (Embedding e : resultIterator.getEmbeddings()) {
                        this.run(resultIterator.getResultIterator(e));
                        if (ClassNameList.this.controller == null) continue;
                        return;
                    }
                }
            });
            if (this.controller == null) {
                this.controller = null;
                return;
            }
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace(ex);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        ElementHandle<TypeElement> handle = TypeElementFinder.find(this.classpathInfo, this.customizer);
        if (handle == null) {
            return;
        }
        this.insertRow(handle.getQualifiedName(), true);
    }

    private void reinsertRow(int index) {
        String qn = (String)this.model.getValueAt(index, 0);
        boolean sel = this.listClasses.isRowSelected(index);
        this.model.removeRow(index);
        this.insertRow(qn, sel);
    }

    private void insertRow(String qn, boolean setSelection) {
        int newIndex;
        int where;
        Object[] all = new String[this.model.getRowCount()];
        for (int i = 0; i < all.length; ++i) {
            all[i] = (String)this.model.getValueAt(i, 0);
        }
        if (!this.ordered) {
            where = Arrays.binarySearch(all, qn);
            if (where >= 0) {
                newIndex = where;
            } else {
                newIndex = -(where + 1);
                this.model.insertRow(newIndex, new Object[]{qn});
            }
        } else {
            where = Arrays.asList(all).indexOf(qn);
            if (where != -1) {
                this.listClasses.getSelectionModel().setSelectionInterval(where, where);
                return;
            }
            if (this.listClasses.getSelectionModel().isSelectionEmpty()) {
                this.model.addRow(new Object[]{qn});
                where = this.model.getRowCount() - 1;
            } else {
                int anchor = this.listClasses.getSelectionModel().getAnchorSelectionIndex();
                this.model.insertRow(anchor, new Object[]{qn});
                where = anchor;
            }
            newIndex = where;
        }
        this.listClasses.getSelectionModel().setSelectionInterval(newIndex, newIndex);
        Rectangle cell = this.listClasses.getCellRect(newIndex, 0, true);
        this.listClasses.scrollRectToVisible(cell);
        this.fireStateChange();
    }

    public static class ExTable
    extends JTable {
        @Override
        public String getToolTipText(MouseEvent ev) {
            return super.getToolTipText(ev);
        }
    }

    private class ValidatingCellEditor
    extends DefaultCellEditor
    implements DocumentListener {
        private JTextComponent editor;
        private Color defColor;
        private boolean contentsOK;

        public ValidatingCellEditor() {
            super(new JTextField());
            this.editor = (JTextField)this.editorComponent;
            this.editor.getDocument().addDocumentListener(this);
            this.defColor = this.editor.getForeground();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void textChanged() {
            String ident = ((JTextComponent)this.editorComponent).getText().trim();
            StringTokenizer tukac = new StringTokenizer(ident, ".", false);
            boolean ok = true;
            while (ok && tukac.hasMoreTokens()) {
                String t = tukac.nextToken();
                if (t.length() == 0 && tukac.hasMoreTokens()) {
                    ok = false;
                    continue;
                }
                ok &= BaseUtilities.isJavaIdentifier(t);
            }
            Color c = ok ? this.defColor : UIManager.getColor("nb.errorForeground");
            this.editor.setForeground(c);
            this.contentsOK = ok;
        }

        @Override
        public boolean stopCellEditing() {
            boolean editing = ClassNameList.this.listClasses.isEditing();
            boolean x = super.stopCellEditing();
            if (!editing) {
                return x;
            }
            if (ClassNameList.this.ordered) {
                ClassNameList.this.fireStateChange();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int currentIndex = ClassNameList.this.listClasses.getEditingRow();
                        if (currentIndex != -1) {
                            ClassNameList.this.reinsertRow(currentIndex);
                        }
                    }
                });
            }
            return x;
        }
    }

    private static class EnableAwareRenderer
    implements TableCellRenderer {
        private EnableAwareRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer def = table.getDefaultRenderer(table.getColumnClass(column));
            if (!table.isEnabled()) {
                hasFocus = false;
                isSelected = false;
            }
            JComponent c = (JComponent)def.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setEnabled(table.isEnabled());
            return c;
        }
    }
}

