/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.LabeledStatementTree;
import jpt.sun.source.tree.LambdaExpressionTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.analysis.api.CodeAnalysis;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.modules.java.hints.spiimpl.SPIAccessor;
import org.netbeans.modules.java.hints.spiimpl.SyntheticFix;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.netbeans.spi.java.hints.Bundle;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class ErrorDescriptionFactory {
    private static final Logger LOG = Logger.getLogger(ErrorDescriptionFactory.class.getName());
    private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.VARIABLE});

    private ErrorDescriptionFactory() {
    }

    public static ErrorDescription forTree(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forTree(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forTree(HintContext context, Tree tree, String text, Fix ... fixes) {
        int end;
        int start;
        if (context.getHintMetadata().kind == Hint.Kind.INSPECTION) {
            start = (int)context.getInfo().getTrees().getSourcePositions().getStartPosition(context.getInfo().getCompilationUnit(), tree);
            int javacEnd = (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree);
            end = Math.min(javacEnd, ErrorDescriptionFactory.findLineEnd(context.getInfo(), start));
        } else {
            int javacEnd = end = context.getCaretLocation();
            start = end;
        }
        if (start != -1 && end != -1) {
            if (start > end) {
                LOG.log(Level.WARNING, "Wrong positions reported for tree (start = {0}, end = {1}): {2}", new Object[]{start, end, tree});
            }
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription("text/x-java:" + context.getHintMetadata().id, context.getSeverity(), text, (CharSequence)context.getHintMetadata().description, fixesForED, context.getInfo().getFileObject(), start, end);
        }
        return null;
    }

    public static ErrorDescription forSpan(HintContext context, int start, int end, String text, Fix ... fixes) {
        if (context.getHintMetadata().kind != Hint.Kind.INSPECTION) {
            start = end = context.getCaretLocation();
        }
        if (start != -1 && end != -1) {
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription("text/x-java:" + context.getHintMetadata().id, context.getSeverity(), text, (CharSequence)context.getHintMetadata().description, fixesForED, context.getInfo().getFileObject(), start, end);
        }
        return null;
    }

    public static ErrorDescription forName(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forName(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forName(HintContext context, Tree tree, String text, Fix ... fixes) {
        int[] span = context.getHintMetadata().kind == Hint.Kind.INSPECTION ? ErrorDescriptionFactory.computeNameSpan(tree, context) : new int[]{context.getCaretLocation(), context.getCaretLocation()};
        if (span != null && span[0] != -1 && span[1] != -1) {
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription("text/x-java:" + context.getHintMetadata().id, context.getSeverity(), text, (CharSequence)context.getHintMetadata().description, fixesForED, context.getInfo().getFileObject(), span[0], span[1]);
        }
        return null;
    }

    private static int[] computeNameSpan(Tree tree, HintContext context) {
        switch (tree.getKind()) {
            case LABELED_STATEMENT: {
                return context.getInfo().getTreeUtilities().findNameSpan((LabeledStatementTree)tree);
            }
            case METHOD: {
                return context.getInfo().getTreeUtilities().findNameSpan((MethodTree)tree);
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return context.getInfo().getTreeUtilities().findNameSpan((ClassTree)tree);
            }
            case VARIABLE: {
                return context.getInfo().getTreeUtilities().findNameSpan((VariableTree)tree);
            }
            case MEMBER_SELECT: {
                MemberSelectTree mst = (MemberSelectTree)tree;
                int[] span = context.getInfo().getTreeUtilities().findNameSpan(mst);
                if (span == null) {
                    int end = (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree);
                    span = new int[]{end - mst.getIdentifier().length(), end};
                }
                return span;
            }
            case METHOD_INVOCATION: {
                return ErrorDescriptionFactory.computeNameSpan(((MethodInvocationTree)tree).getMethodSelect(), context);
            }
            case BLOCK: {
                BlockTree bt;
                Collection<? extends TreePath> prefix = context.getMultiVariables().get("$$1$");
                if (prefix == null || (bt = (BlockTree)tree).getStatements().size() <= prefix.size()) break;
                return ErrorDescriptionFactory.computeNameSpan(bt.getStatements().get(prefix.size()), context);
            }
        }
        int start = (int)context.getInfo().getTrees().getSourcePositions().getStartPosition(context.getInfo().getCompilationUnit(), tree);
        if (StatementTree.class.isAssignableFrom(tree.getKind().asInterface()) && tree.getKind() != Tree.Kind.EXPRESSION_STATEMENT && tree.getKind() != Tree.Kind.BLOCK) {
            TokenSequence<?> ts = context.getInfo().getTokenHierarchy().tokenSequence();
            ts.move(start);
            if (ts.moveNext()) {
                return new int[]{ts.offset(), ts.offset() + ts.token().length()};
            }
        }
        return new int[]{start, Math.min((int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree), ErrorDescriptionFactory.findLineEnd(context.getInfo(), start))};
    }

    private static int findLineEnd(CompilationInfo info, int start) {
        String text = info.getText();
        for (int i = start + 1; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            return i;
        }
        return text.length();
    }

    static List<Fix> resolveDefaultFixes(HintContext ctx, Fix ... provided) {
        LinkedList<Fix> auxiliaryFixes = new LinkedList<Fix>();
        HintMetadata hm = SPIAccessor.getINSTANCE().getHintMetadata(ctx);
        if (hm != null) {
            LinkedHashSet<String> suppressWarningsKeys = new LinkedHashSet<String>();
            for (String string : hm.suppressWarnings) {
                if (string == null || string.length() == 0) break;
                suppressWarningsKeys.add(string);
            }
            auxiliaryFixes.add(new DisableConfigure(ctx.getInfo().getFileObject(), hm, true, SPIAccessor.getINSTANCE().getHintSettings(ctx)));
            auxiliaryFixes.add(new DisableConfigure(ctx.getInfo().getFileObject(), hm, false, null));
            if (hm.kind == Hint.Kind.INSPECTION && !hm.options.contains((Object)HintMetadata.Options.NO_BATCH)) {
                auxiliaryFixes.add(new InspectFix(hm, false));
                if (!hm.options.contains((Object)HintMetadata.Options.QUERY)) {
                    auxiliaryFixes.add(new InspectFix(hm, true));
                }
            }
            if (!suppressWarningsKeys.isEmpty()) {
                auxiliaryFixes.addAll(ErrorDescriptionFactory.createSuppressWarnings(ctx.getInfo(), ctx.getPath(), suppressWarningsKeys.toArray(new String[0])));
            }
            LinkedList<Fix> result = new LinkedList<Fix>();
            for (Fix f : provided != null ? provided : new Fix[]{}) {
                if (f == null) continue;
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes(f, auxiliaryFixes));
            }
            if (result.isEmpty()) {
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes(new TopLevelConfigureFix(ctx.getInfo().getFileObject(), hm), auxiliaryFixes));
            }
            return result;
        }
        return Arrays.asList(provided);
    }

    static Fix createSuppressWarningsFix(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull("compilationInfo", compilationInfo);
        Parameters.notNull("treePath", treePath);
        Parameters.notNull("keys", keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        if (!ErrorDescriptionFactory.isSuppressWarningsSupported(compilationInfo)) {
            return null;
        }
        while (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            return new FixImpl(TreePathHandle.create(treePath, compilationInfo), compilationInfo.getFileObject(), keys);
        }
        return null;
    }

    static List<Fix> createSuppressWarnings(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull("compilationInfo", compilationInfo);
        Parameters.notNull("treePath", treePath);
        Parameters.notNull("keys", keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        Fix f = ErrorDescriptionFactory.createSuppressWarningsFix(compilationInfo, treePath, keys);
        if (f != null) {
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    private static boolean isSuppressWarningsSupported(CompilationInfo info) {
        if (info.getElements().getTypeElement("java.lang.SuppressWarnings") == null) {
            return false;
        }
        return info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
    }

    private static final class FixImpl
    implements Fix,
    SyntheticFix {
        private String[] keys;
        private TreePathHandle handle;
        private FileObject file;

        public FixImpl(TreePathHandle handle, FileObject file, String ... keys) {
            this.keys = keys;
            this.handle = handle;
            this.file = file;
        }

        @Override
        public String getText() {
            StringBuilder keyNames = new StringBuilder();
            for (int i = 0; i < this.keys.length; ++i) {
                String string = this.keys[i];
                keyNames.append(string);
                if (i >= this.keys.length - 1) continue;
                keyNames.append(", ");
            }
            return NbBundle.getMessage(ErrorDescriptionFactory.class, "LBL_FIX_Suppress_Waning", keyNames.toString());
        }

        @Override
        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject(this.file);
            js.runModificationTask(new Task<WorkingCopy>(){

                @Override
                public void run(WorkingCopy copy) throws IOException {
                    TreePath path;
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    for (path = handle.resolve(copy); path != null && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)path.getLeaf().getKind()); path = path.getParentPath()) {
                    }
                    if (path == null || path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        return;
                    }
                    Tree top = path.getLeaf();
                    ModifiersTree modifiers = null;
                    TreePath lambdaPath = null;
                    switch (top.getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            modifiers = ((ClassTree)top).getModifiers();
                            break;
                        }
                        case METHOD: {
                            modifiers = ((MethodTree)top).getModifiers();
                            break;
                        }
                        case VARIABLE: {
                            if (path.getParentPath() != null && path.getParentPath().getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                                TreePath typePath = TreePath.getPath(path.getParentPath(), ((VariableTree)top).getType());
                                if (copy.getTreeUtilities().isSynthetic(typePath)) {
                                    lambdaPath = path.getParentPath();
                                }
                            }
                            modifiers = ((VariableTree)top).getModifiers();
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled Tree.Kind";
                            break;
                        }
                    }
                    if (modifiers == null) {
                        return;
                    }
                    TypeElement el = copy.getElements().getTypeElement("java.lang.SuppressWarnings");
                    if (el == null) {
                        return;
                    }
                    ExpressionTree[] keyLiterals = new LiteralTree[keys.length];
                    for (int i = 0; i < keys.length; ++i) {
                        keyLiterals[i] = copy.getTreeMaker().Literal(keys[i]);
                    }
                    if (lambdaPath != null) {
                        LambdaExpressionTree let = (LambdaExpressionTree)lambdaPath.getLeaf();
                        for (VariableTree variableTree : let.getParameters()) {
                            TreePath typePath = TreePath.getPath(lambdaPath, variableTree.getType());
                            if (!copy.getTreeUtilities().isSynthetic(typePath)) continue;
                            Tree imported = copy.getTreeMaker().Type(copy.getTrees().getTypeMirror(typePath));
                            copy.rewrite(variableTree.getType(), imported);
                        }
                    }
                    ModifiersTree nueMods = GeneratorUtilities.get(copy).appendToAnnotationValue(modifiers, el, "value", keyLiterals);
                    copy.rewrite(modifiers, nueMods);
                }
            }).commit();
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixImpl other = (FixImpl)obj;
            if (!Arrays.deepEquals(this.keys, other.keys)) {
                return false;
            }
            if (!(this.handle == other.handle || this.handle != null && this.handle.equals(other.handle))) {
                return false;
            }
            return this.file == other.file || this.file != null && this.file.equals(other.file);
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Arrays.deepHashCode(this.keys);
            hash = 79 * hash + (this.handle != null ? this.handle.hashCode() : 0);
            hash = 79 * hash + (this.file != null ? this.file.hashCode() : 0);
            return hash;
        }
    }

    private static class InspectFix
    implements Fix,
    SyntheticFix {
        @NonNull
        private final HintMetadata metadata;
        private final boolean transform;

        InspectFix(@NonNull HintMetadata metadata, boolean transform) {
            this.metadata = metadata;
            this.transform = transform;
        }

        @Override
        public String getText() {
            return this.transform ? Bundle.DN_InspectAndTransform() : Bundle.DN_Inspect();
        }

        @Override
        public ChangeInfo implement() throws Exception {
            SwingUtilities.invokeLater(() -> {
                if (this.transform) {
                    Hacks.InspectAndTransformOpener o = Lookup.getDefault().lookup(Hacks.InspectAndTransformOpener.class);
                    if (o != null) {
                        o.openIAT(this.metadata);
                    }
                } else {
                    CodeAnalysis.open(Analyzer.WarningDescription.create("text/x-java:" + this.metadata.id, null, null, null));
                }
            });
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InspectFix other = (InspectFix)obj;
            if (!(this.metadata == other.metadata || this.metadata != null && this.metadata.equals(other.metadata))) {
                return false;
            }
            return this.transform == other.transform;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + (this.metadata != null ? this.metadata.hashCode() : 0);
            hash = 43 * hash + (this.transform ? 1 : 0);
            return hash;
        }
    }

    private static final class TopLevelConfigureFix
    extends DisableConfigure
    implements EnhancedFix {
        public TopLevelConfigureFix(@NonNull FileObject file, @NonNull HintMetadata metadata) {
            super(file, metadata, false, null);
        }

        @Override
        public CharSequence getSortText() {
            return "\uffffzz";
        }
    }

    private static class DisableConfigure
    implements Fix,
    SyntheticFix {
        @NonNull
        private final FileObject file;
        @NonNull
        private final HintMetadata metadata;
        private final boolean disable;
        private final HintsSettings hintsSettings;

        DisableConfigure(@NonNull FileObject file, @NonNull HintMetadata metadata, boolean disable, HintsSettings hintsSettings) {
            this.file = file;
            this.metadata = metadata;
            this.disable = disable;
            this.hintsSettings = hintsSettings;
        }

        @Override
        public String getText() {
            String key;
            String displayName = this.metadata.displayName;
            switch (this.metadata.kind) {
                case INSPECTION: {
                    key = this.disable ? "FIX_DisableHint" : "FIX_ConfigureHint";
                    break;
                }
                case ACTION: {
                    key = this.disable ? "FIX_DisableSuggestion" : "FIX_ConfigureSuggestion";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return NbBundle.getMessage(ErrorDescriptionFactory.class, key, displayName);
        }

        @Override
        public ChangeInfo implement() throws Exception {
            if (this.disable) {
                this.hintsSettings.setEnabled(this.metadata, false);
            } else {
                FileHintPreferences.openFilePreferences(this.file, "text/x-java", this.metadata.id);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DisableConfigure other = (DisableConfigure)obj;
            if (!(this.metadata == other.metadata || this.metadata != null && this.metadata.equals(other.metadata))) {
                return false;
            }
            return this.disable == other.disable;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + (this.metadata != null ? this.metadata.hashCode() : 0);
            hash = 43 * hash + (this.disable ? 1 : 0);
            return hash;
        }
    }
}

