/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.project.classpath.ProjectClassPathModifierAccessor;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class ProjectClassPathModifierImplementation {
    protected ProjectClassPathModifierImplementation() {
    }

    protected abstract SourceGroup[] getExtensibleSourceGroups();

    protected abstract String[] getExtensibleClassPathTypes(SourceGroup var1);

    protected abstract boolean addLibraries(Library[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected abstract boolean removeLibraries(Library[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected abstract boolean addRoots(URL[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected boolean addRoots(URI[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        return this.addRoots(ProjectClassPathModifierImplementation.convertURIsToURLs(classPathRoots), sourceGroup, type);
    }

    private static URL[] convertURIsToURLs(URI[] uris) {
        ArrayList<URL> content = new ArrayList<URL>();
        for (URI uri : uris) {
            if (!uri.isAbsolute()) {
                throw new UnsupportedOperationException("default modifier handles only absolute URIs - " + uri);
            }
            try {
                content.add(uri.toURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        return content.toArray(new URL[content.size()]);
    }

    protected static URI[] convertURLsToURIs(URL[] entry) {
        ArrayList<URI> content = new ArrayList<URI>();
        for (URL url : entry) {
            content.add(URI.create(url.toExternalForm()));
        }
        return content.toArray(new URI[content.size()]);
    }

    protected abstract boolean removeRoots(URL[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected boolean removeRoots(URI[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        return this.removeRoots(ProjectClassPathModifierImplementation.convertURIsToURLs(classPathRoots), sourceGroup, type);
    }

    protected abstract boolean addAntArtifacts(AntArtifact[] var1, URI[] var2, SourceGroup var3, String var4) throws IOException, UnsupportedOperationException;

    protected abstract boolean removeAntArtifacts(AntArtifact[] var1, URI[] var2, SourceGroup var3, String var4) throws IOException, UnsupportedOperationException;

    protected boolean addProjects(Project[] projects, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        ArrayList<AntArtifact> ants = new ArrayList<AntArtifact>();
        ArrayList<URI> antUris = new ArrayList<URI>();
        for (Project prj : projects) {
            AntArtifact[] antArtifacts;
            for (AntArtifact aa : antArtifacts = AntArtifactQuery.findArtifactsByType(prj, "jar")) {
                ants.add(aa);
                antUris.add(aa.getArtifactLocations()[0]);
            }
        }
        return this.addAntArtifacts(ants.toArray(new AntArtifact[0]), antUris.toArray(new URI[0]), sourceGroup, type);
    }

    protected final String performSharabilityHeuristics(URI classpathRoot, AntProjectHelper helper) throws URISyntaxException, IOException {
        String f;
        File prjRoot;
        File file;
        assert (classpathRoot != null);
        assert (classpathRoot.toString().endsWith("/")) : "Folder URI must end with '/'. Was: " + classpathRoot;
        URI toAdd = LibrariesSupport.getArchiveFile(classpathRoot);
        if (toAdd == null) {
            toAdd = classpathRoot;
        }
        if (CollocationQuery.areCollocated(file = PropertyUtils.resolveFile(prjRoot = FileUtil.toFile(helper.getProjectDirectory()), LibrariesSupport.convertURIToFilePath(toAdd)), prjRoot)) {
            f = PropertyUtils.relativizeFile(prjRoot, file);
        } else if (helper.isSharableProject()) {
            File library = PropertyUtils.resolveFile(prjRoot, helper.getLibrariesLocation());
            boolean fileLibraryCol = CollocationQuery.areCollocated(library.getParentFile(), file);
            boolean libraryAbsolute = LibrariesSupport.convertFilePathToURI(helper.getLibrariesLocation()).isAbsolute();
            if (libraryAbsolute && fileLibraryCol) {
                f = file.getAbsolutePath();
            } else if (libraryAbsolute && !fileLibraryCol) {
                File fl = this.copyFile(file, FileUtil.toFileObject(library.getParentFile()));
                f = fl.getAbsolutePath();
            } else if (!libraryAbsolute && fileLibraryCol) {
                f = PropertyUtils.relativizeFile(prjRoot, file);
            } else {
                File fl = this.copyFile(file, FileUtil.toFileObject(library.getParentFile()));
                f = PropertyUtils.relativizeFile(prjRoot, fl);
            }
        } else {
            f = file.getAbsolutePath();
        }
        return f;
    }

    private File copyFile(File file, FileObject newRoot) throws IOException {
        FileObject fo = FileUtil.toFileObject(file);
        if (fo.isFolder()) {
            return FileUtil.toFile(this.copyFolderRecursively(fo, newRoot));
        }
        FileObject foExists = newRoot.getFileObject(fo.getName(), fo.getExt());
        if (foExists != null) {
            foExists.delete();
        }
        return FileUtil.toFile(FileUtil.copyFile(fo, newRoot, fo.getName(), fo.getExt()));
    }

    private FileObject copyFolderRecursively(FileObject sourceFolder, FileObject destination) throws IOException {
        assert (sourceFolder.isFolder()) : sourceFolder;
        assert (destination.isFolder()) : destination;
        FileObject destinationSubFolder = destination.getFileObject(sourceFolder.getName());
        if (destinationSubFolder == null) {
            destinationSubFolder = destination.createFolder(sourceFolder.getName());
        }
        for (FileObject fo : sourceFolder.getChildren()) {
            if (fo.isFolder()) {
                this.copyFolderRecursively(fo, destinationSubFolder);
                continue;
            }
            FileObject foExists = destinationSubFolder.getFileObject(fo.getName(), fo.getExt());
            if (foExists != null) {
                foExists.delete();
            }
            FileUtil.copyFile(fo, destinationSubFolder, fo.getName(), fo.getExt());
        }
        return destinationSubFolder;
    }

    static {
        ProjectClassPathModifierAccessor.INSTANCE = new Accessor();
    }

    private static class Accessor
    extends ProjectClassPathModifierAccessor {
        private Accessor() {
        }

        @Override
        public SourceGroup[] getExtensibleSourceGroups(ProjectClassPathModifierImplementation m) {
            assert (m != null);
            return m.getExtensibleSourceGroups();
        }

        @Override
        public String[] getExtensibleClassPathTypes(ProjectClassPathModifierImplementation m, SourceGroup sg) {
            assert (m != null);
            assert (sg != null);
            return m.getExtensibleClassPathTypes(sg);
        }

        @Override
        public boolean removeLibraries(Library[] libraries, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.removeLibraries(libraries, sourceGroup, type);
        }

        @Override
        public boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.removeAntArtifacts(artifacts, artifactElements, sourceGroup, type);
        }

        @Override
        public boolean addLibraries(Library[] libraries, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.addLibraries(libraries, sourceGroup, type);
        }

        @Override
        public boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.addAntArtifacts(artifacts, artifactElements, sourceGroup, type);
        }

        @Override
        public boolean removeRoots(URL[] classPathRoots, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.removeRoots(classPathRoots, sourceGroup, type);
        }

        @Override
        public boolean removeRoots(URI[] classPathRoots, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.removeRoots(classPathRoots, sourceGroup, type);
        }

        @Override
        public boolean addRoots(URL[] classPathRoots, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.addRoots(classPathRoots, sourceGroup, type);
        }

        @Override
        public boolean addRoots(URI[] classPathRoots, ProjectClassPathModifierImplementation m, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            assert (m != null);
            return m.addRoots(classPathRoots, sourceGroup, type);
        }

        @Override
        public boolean addProjects(Project[] projects, ProjectClassPathModifierImplementation pcmi, SourceGroup sg, String classPathType) throws IOException, UnsupportedOperationException {
            assert (pcmi != null);
            return pcmi.addProjects(projects, sg, classPathType);
        }
    }
}

