/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public abstract class NodeAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final long serialVersionUID = -5672895970450115226L;
    private static final String PROP_HAS_LISTENERS = "hasListeners";
    private static final String PROP_LAST_NODES = "lastNodes";
    private static final String PROP_LAST_ENABLED = "lastEnabled";
    private static NodesL l;
    private static final Set<NodeAction> listeningActions;

    @Override
    protected void initialize() {
        super.initialize();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addNotify() {
        super.addNotify();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.TRUE);
        Set<NodeAction> set = listeningActions;
        synchronized (set) {
            if (l == null) {
                l = new NodesL();
            }
            if (listeningActions.isEmpty()) {
                l.setActive(true);
            }
            listeningActions.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNotify() {
        Set<NodeAction> set = listeningActions;
        synchronized (set) {
            listeningActions.remove(this);
            if (listeningActions.isEmpty()) {
                l.setActive(false);
            }
        }
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        Object[] ns = null;
        Boolean b = null;
        Object object = this.getLock();
        synchronized (object) {
            b = (Boolean)this.getProperty("enabled");
            if (l == null) {
                l = new NodesL();
                l.setActive(true);
            }
            NodesL listener = l;
            if (b == null) {
                ns = listener.getActivatedNodes(this.surviveFocusChange());
                Reference r = (Reference)this.getProperty(PROP_LAST_NODES);
                if (r != null && Arrays.equals((Node[])r.get(), ns)) {
                    b = (Boolean)this.getProperty(PROP_LAST_ENABLED);
                    if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                        this.putProperty("enabled", b);
                    }
                }
            }
        }
        if (b == null) {
            b = ns != null && this.enable((Node[])ns) ? Boolean.TRUE : Boolean.FALSE;
            object = this.getLock();
            synchronized (object) {
                this.putProperty(PROP_LAST_NODES, new WeakReference<Object[]>(ns));
                this.putProperty(PROP_LAST_ENABLED, b);
                if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                    this.putProperty("enabled", b);
                }
            }
        }
        return b;
    }

    @Override
    public void setEnabled(boolean e) {
        this.putProperty(PROP_LAST_ENABLED, null);
        this.putProperty(PROP_LAST_NODES, null);
        Boolean propHasListener = (Boolean)this.getProperty(PROP_HAS_LISTENERS);
        if (propHasListener != null && propHasListener.booleanValue()) {
            super.setEnabled(e);
        } else {
            this.putProperty("enabled", null, true);
        }
    }

    @Override
    @Deprecated
    public void actionPerformed(ActionEvent ev) {
        Object s;
        Object object = s = ev == null ? null : ev.getSource();
        if (s instanceof Node) {
            ActionInvoker.invokeAction(this, ev, this.amIasynchronous(), new Runnable(){

                @Override
                public void run() {
                    NodeAction.this.performAction(new Node[]{(Node)s});
                }
            });
        } else if (s instanceof Node[]) {
            ActionInvoker.invokeAction(this, ev, this.amIasynchronous(), new Runnable(){

                @Override
                public void run() {
                    NodeAction.this.performAction((Node[])s);
                }
            });
        } else {
            super.actionPerformed(ev);
        }
    }

    @Override
    @Deprecated
    public void performAction() {
        this.performAction(this.getActivatedNodes());
    }

    public final Node[] getActivatedNodes() {
        NodesL listener = l;
        return listener == null ? new Node[]{} : listener.getActivatedNodes(true);
    }

    protected boolean surviveFocusChange() {
        return true;
    }

    protected abstract void performAction(Node[] var1);

    protected abstract boolean enable(Node[] var1);

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeFireEnabledChange() {
        boolean fire = false;
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty("enabled") != null) {
                this.putProperty("enabled", null);
                fire = true;
            }
        }
        if (fire) {
            try {
                this.firePropertyChange("enabled", null, null);
            }
            catch (NullPointerException e) {
                Exceptions.attachMessage(e, "You cannot add " + this.getClass().getName() + " directly to a JMenu etc.; use org.openide.awt.Actions.connect instead");
                Logger.getLogger(NodeAction.class.getName()).log(Level.WARNING, null, e);
            }
        }
    }

    final boolean amIasynchronous() {
        return this.asynchronous();
    }

    static {
        listeningActions = new WeakSet<NodeAction>(100);
    }

    static class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        private static final Node[] EMPTY_NODE_ARRAY = new Node[0];
        private NodeAction delegate;
        private Lookup.Result<Node> result;
        private boolean enabled = true;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(NodeAction a, Lookup actionContext) {
            this.delegate = a;
            this.result = actionContext.lookupResult(Node.class);
            this.result.addLookupListener(WeakListeners.create(LookupListener.class, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public final synchronized Node[] nodes() {
            if (this.result != null) {
                return this.result.allInstances().toArray(EMPTY_NODE_ARRAY);
            }
            return EMPTY_NODE_ARRAY;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionInvoker.invokeAction(this.delegate, e, this.delegate.amIasynchronous(), new Runnable(){

                @Override
                public void run() {
                    delegate.performAction(this.nodes());
                }
            });
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        @Override
        public void putValue(String key, Object o) {
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            final boolean old = this.enabled;
            this.enabled = this.delegate.enable(this.nodes());
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    support.firePropertyChange("enabled", old, enabled);
                }
            });
        }

        @Override
        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverridden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return new Actions.MenuItem(this, true);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverridden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return new Actions.MenuItem(this, false);
        }

        @Override
        public Component getToolbarPresenter() {
            if (this.isMethodOverridden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return new Actions.ToolbarButton(this);
        }

        private boolean isMethodOverridden(NodeAction d, String name) {
            try {
                Method m = d.getClass().getMethod(name, new Class[0]);
                return m.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d);
            }
        }
    }

    private static final class NodesL
    implements LookupListener {
        private volatile Lookup.Result<Node> result;
        private boolean chgSFC = false;
        private boolean chgNSFC = false;
        private Reference<Node>[] activatedNodes;

        public Node[] getActivatedNodes(boolean survive) {
            Lookup.Result<Node> r;
            block3: {
                if (survive && this.activatedNodes != null) {
                    Node[] arr = new Node[this.activatedNodes.length];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = this.activatedNodes[i].get();
                        if (arr[i] != null) {
                            continue;
                        }
                        break block3;
                    }
                    return arr;
                }
            }
            return (r = this.result) == null ? new Node[]{} : r.allInstances().toArray(new Node[0]);
        }

        synchronized void setActive(boolean active) {
            Lookup context = Utilities.actionsGlobalContext();
            if (active) {
                if (this.result == null) {
                    this.result = context.lookupResult(Node.class);
                    this.result.addLookupListener(this);
                }
            } else {
                this.forget(true);
                this.forget(false);
            }
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            Lookup.Item<Node> item;
            Lookup.Result<Node> r = this.result;
            if (r == null) {
                return;
            }
            this.chgSFC = true;
            this.chgNSFC = true;
            Collection<Lookup.Item<Node>> items = this.result.allItems();
            boolean updateActivatedNodes = true;
            if (items.size() == 1 && "none".equals((item = items.iterator().next()).getId()) && item.getInstance() == null) {
                updateActivatedNodes = false;
            }
            if (updateActivatedNodes) {
                Iterator<Node> it = this.result.allInstances().iterator();
                ArrayList<WeakReference<Node>> list = new ArrayList<WeakReference<Node>>();
                while (it.hasNext()) {
                    list.add(new WeakReference<Node>(it.next()));
                }
                this.activatedNodes = list.toArray(new Reference[list.size()]);
            }
            this.update();
        }

        public void update() {
            if (this.chgSFC) {
                this.forget(true);
                this.chgSFC = false;
            }
            if (this.chgNSFC) {
                this.forget(false);
                this.chgNSFC = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forget(boolean sfc) {
            ArrayList<NodeAction> as;
            Set set = listeningActions;
            synchronized (set) {
                as = new ArrayList<NodeAction>(listeningActions.size());
                Iterator it = listeningActions.iterator();
                while (it.hasNext()) {
                    as.add((NodeAction)it.next());
                }
            }
            for (final NodeAction a : as) {
                if (a.surviveFocusChange() != sfc) continue;
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        a.maybeFireEnabledChange();
                    }
                });
            }
        }
    }
}

