/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration.java;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Processor;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lsp.CompletionCollector;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class AnnotationProcessorCompletionCollector
implements CompletionCollector {
    private static final Lookup HARDCODED_PROCESSORS = Lookups.forPath((String)"Editors/text/x-java/AnnotationProcessors");
    private static final String COMPLETION_CASE_SENSITIVE = "completion-case-sensitive";
    private static final boolean COMPLETION_CASE_SENSITIVE_DEFAULT = true;
    private static final String JAVA_COMPLETION_SUBWORDS = "javaCompletionSubwords";
    private static final boolean JAVA_COMPLETION_SUBWORDS_DEFAULT = false;
    private static final PreferenceChangeListener preferencesTracker = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || AnnotationProcessorCompletionCollector.COMPLETION_CASE_SENSITIVE.equals(settingName)) {
                caseSensitive = preferences.getBoolean(AnnotationProcessorCompletionCollector.COMPLETION_CASE_SENSITIVE, true);
            }
            if (settingName == null || AnnotationProcessorCompletionCollector.JAVA_COMPLETION_SUBWORDS.equals(settingName)) {
                javaCompletionSubwords = preferences.getBoolean(AnnotationProcessorCompletionCollector.JAVA_COMPLETION_SUBWORDS, false);
            }
        }
    };
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private static Preferences preferences;
    private static boolean caseSensitive;
    private static boolean javaCompletionSubwords;
    private static String cachedPrefix;
    private static Pattern cachedCamelCasePattern;
    private static Pattern cachedSubwordsPattern;

    public boolean collectCompletions(Document doc, final int offset, Completion.Context context, final Consumer<org.netbeans.api.lsp.Completion> consumer) {
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){
                private String prefix;
                private int anchorOffset;

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                    if (cc != null) {
                        int len;
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        int tokenOffset = this.anchorOffset = offset;
                        this.prefix = "";
                        TokenSequence ts = cc.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                        if (ts.move(this.anchorOffset) == 0 || !ts.moveNext()) {
                            ts.movePrevious();
                        }
                        if ((len = this.anchorOffset - ts.offset()) > 0 && ts.token().length() >= len) {
                            if (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal")) {
                                this.prefix = ts.token().text().toString().substring(0, len);
                                tokenOffset = this.anchorOffset = ts.offset();
                            } else if (ts.token().id() == JavaTokenId.STRING_LITERAL) {
                                this.prefix = ts.token().text().toString().substring(1, Math.min(len, ts.token().length() - 1));
                                tokenOffset = ts.offset();
                                this.anchorOffset = tokenOffset + 1;
                            } else if (ts.token().id() == JavaTokenId.MULTILINE_STRING_LITERAL) {
                                this.prefix = ts.token().text().toString().substring(3, len);
                                tokenOffset = ts.offset();
                                this.anchorOffset = tokenOffset + 3;
                            }
                        }
                        TreeUtilities treeUtilities = cc.getTreeUtilities();
                        Trees trees = cc.getTrees();
                        SourcePositions sp = trees.getSourcePositions();
                        TreePath path = treeUtilities.pathFor(tokenOffset);
                        switch (path.getLeaf().getKind()) {
                            case ANNOTATION: 
                            case TYPE_ANNOTATION: {
                                TokenSequence last;
                                Tree annotationType = ((AnnotationTree)path.getLeaf()).getAnnotationType();
                                int typeEndPos = (int)sp.getEndPosition(cc.getCompilationUnit(), annotationType);
                                if (tokenOffset <= typeEndPos || (last = AnnotationProcessorCompletionCollector.findLastNonWhitespaceToken(cc, typeEndPos, tokenOffset)) == null || last.token().id() != JavaTokenId.LPAREN) break;
                                Element annTypeElement = trees.getElement(new TreePath(path, annotationType));
                                ExecutableElement valueElement = null;
                                for (Element element : ((TypeElement)annTypeElement).getEnclosedElements()) {
                                    if (element.getKind() != ElementKind.METHOD) continue;
                                    String name = element.getSimpleName().toString();
                                    if ("value".equals(name)) {
                                        valueElement = (ExecutableElement)element;
                                        continue;
                                    }
                                    if (((ExecutableElement)element).getDefaultValue() != null) continue;
                                    valueElement = null;
                                }
                                if (valueElement == null) break;
                                Element el = null;
                                TreePath treePath = path.getParentPath();
                                if (treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                                    el = trees.getElement(treePath);
                                } else {
                                    TreePath treePath2 = treePath.getParentPath();
                                    Tree.Kind pKind = treePath2.getLeaf().getKind();
                                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)pKind) || pKind == Tree.Kind.METHOD || pKind == Tree.Kind.VARIABLE) {
                                        el = trees.getElement(treePath2);
                                    }
                                }
                                if (el == null) break;
                                AnnotationMirror annotation = null;
                                for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
                                    if (annTypeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                    annotation = annotationMirror;
                                    break;
                                }
                                if (annotation == null) break;
                                this.addAttributeValues(cc, el, annotation, valueElement);
                                break;
                            }
                            case ASSIGNMENT: {
                                String string;
                                int eqPos;
                                Tree expr;
                                int varEndPos;
                                ExpressionTree var;
                                TreePath parentPath = path.getParentPath();
                                if (parentPath.getLeaf().getKind() != Tree.Kind.ANNOTATION || (var = ((AssignmentTree)path.getLeaf()).getVariable()).getKind() != Tree.Kind.IDENTIFIER || (varEndPos = (int)sp.getEndPosition(cc.getCompilationUnit(), var)) <= -1 || (expr = AnnotationProcessorCompletionCollector.unwrapErrTree(((AssignmentTree)path.getLeaf()).getExpression())) != null && tokenOffset > (int)sp.getStartPosition(cc.getCompilationUnit(), expr) || (eqPos = (string = cc.getText().substring(varEndPos, tokenOffset)).indexOf(61)) <= -1) break;
                                this.insideAnnotationAttribute(cc, parentPath, ((IdentifierTree)var).getName());
                            }
                        }
                    }
                }

                private void insideAnnotationAttribute(CompilationController controller, TreePath annotationPath, Name attributeName) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Trees trees = controller.getTrees();
                    AnnotationTree at = (AnnotationTree)annotationPath.getLeaf();
                    Element annTypeElement = trees.getElement(new TreePath(annotationPath, at.getAnnotationType()));
                    Element el = null;
                    TreePath pPath = annotationPath.getParentPath();
                    if (pPath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        el = trees.getElement(pPath);
                    } else {
                        Tree.Kind pKind = (pPath = pPath.getParentPath()).getLeaf().getKind();
                        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)pKind) || pKind == Tree.Kind.METHOD || pKind == Tree.Kind.VARIABLE) {
                            el = trees.getElement(pPath);
                        }
                    }
                    if (el != null && annTypeElement != null && annTypeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                        ExecutableElement memberElement = null;
                        for (Element element : ((TypeElement)annTypeElement).getEnclosedElements()) {
                            if (element.getKind() != ElementKind.METHOD || !attributeName.contentEquals(element.getSimpleName())) continue;
                            memberElement = (ExecutableElement)element;
                            break;
                        }
                        if (memberElement != null) {
                            AnnotationMirror annotation = null;
                            for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
                                if (annTypeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                annotation = annotationMirror;
                                break;
                            }
                            if (annotation != null) {
                                this.addAttributeValues(controller, el, annotation, memberElement);
                            }
                        }
                    }
                }

                private void addAttributeValues(CompilationController controller, Element element, AnnotationMirror annotation, ExecutableElement member) throws IOException {
                    for (Completion completion : this.getAttributeValueCompletions(element, annotation, member, this.prefix)) {
                        String value = completion.getValue().trim();
                        if (value.length() <= 0 || !AnnotationProcessorCompletionCollector.startsWith(value, this.prefix)) continue;
                        consumer.accept(this.createAttributeValueItem(controller, value, completion.getMessage()));
                    }
                }

                private List<? extends Completion> getAttributeValueCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
                    LinkedList<Completion> completions = new LinkedList<Completion>();
                    String fqn = ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
                    for (Processor processor : HARDCODED_PROCESSORS.lookupAll(Processor.class)) {
                        boolean match = false;
                        for (String string : processor.getSupportedAnnotationTypes()) {
                            if ("*".equals(string)) {
                                match = true;
                                break;
                            }
                            if (string.endsWith(".*")) {
                                String string2 = string.substring(0, string.length() - 1);
                                if (!fqn.startsWith(string2)) continue;
                                match = true;
                                break;
                            }
                            if (!fqn.equals(string)) continue;
                            match = true;
                            break;
                        }
                        if (!match) continue;
                        try {
                            for (Completion completion : processor.getCompletions(element, annotation, member, userText)) {
                                completions.add(completion);
                            }
                        }
                        catch (Exception e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                    return completions;
                }

                private org.netbeans.api.lsp.Completion createAttributeValueItem(CompilationController controller, String value, String documentation) {
                    String label = value;
                    TextEdit textEdit = null;
                    if (value.startsWith("\"")) {
                        TokenSequence ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                        ts.move(offset);
                        if (ts.moveNext() && ts.offset() <= offset) {
                            switch ((JavaTokenId)ts.token().id()) {
                                case STRING_LITERAL: {
                                    int end = ts.offset() + ts.token().length() == offset + 1 ? offset + 1 : offset;
                                    textEdit = new TextEdit(ts.offset(), end, value);
                                    break;
                                }
                                case MULTILINE_STRING_LITERAL: {
                                    String[] tokenLines = ts.token().text().toString().split("\n");
                                    String[] lines = value.split("\n");
                                    int cnt = 0;
                                    for (int i = 0; i < lines.length; ++i) {
                                        if (i >= tokenLines.length) continue;
                                        if (tokenLines[i].equals(lines[i])) {
                                            cnt += tokenLines[i].length() + 1;
                                            continue;
                                        }
                                        if (i != lines.length - 1) continue;
                                        label = lines[i].trim();
                                        textEdit = new TextEdit(ts.offset() + cnt, offset, lines[i]);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)label).kind(Completion.Kind.Value).sortText(value).insertTextFormat(Completion.TextFormat.PlainText).documentation(documentation);
                    if (textEdit != null) {
                        builder.textEdit(textEdit);
                    }
                    return builder.build();
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    private static TokenSequence<JavaTokenId> findLastNonWhitespaceToken(CompilationController controller, int start, int pos) {
        TokenSequence ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(pos);
        block3: while (ts.movePrevious() && ts.offset() >= start) {
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return ts;
        }
        return null;
    }

    private static Tree unwrapErrTree(Tree tree) {
        if (tree != null && tree.getKind() == Tree.Kind.ERRONEOUS) {
            Iterator<? extends Tree> it = ((ErroneousTree)tree).getErrorTrees().iterator();
            tree = it.hasNext() ? it.next() : null;
        }
        return tree;
    }

    private static boolean startsWith(String theString, String prefix) {
        if (theString.startsWith("\"")) {
            theString = theString.substring(1);
        }
        return AnnotationProcessorCompletionCollector.isCamelCasePrefix(prefix) ? (AnnotationProcessorCompletionCollector.isCaseSensitive() ? AnnotationProcessorCompletionCollector.startsWithCamelCase(theString, prefix) : AnnotationProcessorCompletionCollector.startsWithCamelCase(theString, prefix) || AnnotationProcessorCompletionCollector.startsWithPlain(theString, prefix)) : AnnotationProcessorCompletionCollector.startsWithPlain(theString, prefix);
    }

    private static boolean isCamelCasePrefix(String prefix) {
        if (prefix == null || prefix.length() < 2 || prefix.charAt(0) == '\"') {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (!Character.isUpperCase(prefix.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCaseSensitive() {
        AnnotationProcessorCompletionCollector.lazyInit();
        return caseSensitive;
    }

    private static boolean isSubwordSensitive() {
        AnnotationProcessorCompletionCollector.lazyInit();
        return javaCompletionSubwords;
    }

    private static boolean startsWithPlain(String theString, String prefix) {
        if (theString == null || theString.length() == 0) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        if (AnnotationProcessorCompletionCollector.isSubwordSensitive()) {
            if (!prefix.equals(cachedPrefix)) {
                cachedCamelCasePattern = null;
                cachedSubwordsPattern = null;
            }
            if (cachedSubwordsPattern == null) {
                cachedPrefix = prefix;
                String patternString = AnnotationProcessorCompletionCollector.createSubwordsPattern(prefix);
                Pattern pattern = cachedSubwordsPattern = patternString != null ? Pattern.compile(patternString) : null;
            }
            if (cachedSubwordsPattern != null && cachedSubwordsPattern.matcher(theString).matches()) {
                return true;
            }
        }
        return AnnotationProcessorCompletionCollector.isCaseSensitive() ? theString.startsWith(prefix) : theString.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    private static String createSubwordsPattern(String prefix) {
        StringBuilder sb = new StringBuilder(3 + 8 * prefix.length());
        sb.append(".*?");
        for (int i = 0; i < prefix.length(); ++i) {
            char charAt = prefix.charAt(i);
            if (!Character.isJavaIdentifierPart(charAt)) {
                return null;
            }
            if (Character.isLowerCase(charAt)) {
                sb.append("[");
                sb.append(charAt);
                sb.append(Character.toUpperCase(charAt));
                sb.append("]");
            } else {
                sb.append(charAt);
            }
            sb.append(".*?");
        }
        return sb.toString();
    }

    private static boolean startsWithCamelCase(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        if (!prefix.equals(cachedPrefix)) {
            cachedCamelCasePattern = null;
            cachedSubwordsPattern = null;
        }
        if (cachedCamelCasePattern == null) {
            int index;
            StringBuilder sb = new StringBuilder();
            int lastIndex = 0;
            do {
                String token = prefix.substring(lastIndex, (index = AnnotationProcessorCompletionCollector.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                sb.append(token);
                sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                lastIndex = index;
            } while (index != -1);
            cachedPrefix = prefix;
            cachedCamelCasePattern = Pattern.compile(sb.toString());
        }
        return cachedCamelCasePattern.matcher(theString).matches();
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static void lazyInit() {
        if (inited.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)JavaTokenId.language().mimeType()).lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    static {
        caseSensitive = true;
        javaCompletionSubwords = false;
        cachedPrefix = null;
        cachedCamelCasePattern = null;
        cachedSubwordsPattern = null;
    }
}

