/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.debugger.ui.annotations.WatchAnnotationProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Bundle;
import org.netbeans.spi.debugger.ui.EditorPin;
import org.openide.loaders.DataObjectNotFoundException;

public final class PinWatchUISupport {
    private static final PinWatchUISupport INSTANCE = new PinWatchUISupport();
    private final Object valueProvidersLock = new Object();
    private Map<String, DelegatingValueProvider> valueProviders;

    private PinWatchUISupport() {
        WatchAnnotationProvider.PIN_SUPPORT_ACCESS = new WatchAnnotationProvider.PinSupportedAccessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ValueProvider getValueProvider(EditorPin pin) {
                String id = pin.getVpId();
                if (id == null) {
                    return null;
                }
                Object object = PinWatchUISupport.this.valueProvidersLock;
                synchronized (object) {
                    DelegatingValueProvider vp = (DelegatingValueProvider)PinWatchUISupport.this.getValueProviders().get(id);
                    if (vp == null) {
                        vp = new DelegatingValueProvider(id);
                        PinWatchUISupport.this.valueProviders.put(id, vp);
                    }
                    return vp;
                }
            }
        };
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)new DebuggerManagerAdapter(){

            public void propertyChange(PropertyChangeEvent evt) {
                PinWatchUISupport.this.refreshValueProviders();
            }
        });
    }

    public static PinWatchUISupport getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pin(Watch watch, String valueProviderId) throws IllegalArgumentException {
        Watch.Pin wpin = watch.getPin();
        if (!(wpin instanceof EditorPin)) {
            throw new IllegalArgumentException("Unsupported pin: " + wpin);
        }
        Object object = this.valueProvidersLock;
        synchronized (object) {
            if (!this.getValueProviders().containsKey(valueProviderId)) {
                this.valueProviders.put(valueProviderId, new DelegatingValueProvider(valueProviderId));
            }
        }
        EditorPin pin = (EditorPin)wpin;
        pin.setVpId(valueProviderId);
        try {
            WatchAnnotationProvider.PIN_SUPPORT_ACCESS.pin(watch);
        }
        catch (DataObjectNotFoundException ex) {
            throw new IllegalArgumentException("Unable to find the pin's editor.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DelegatingValueProvider> getValueProviders() {
        Object object = this.valueProvidersLock;
        synchronized (object) {
            if (this.valueProviders == null) {
                this.valueProviders = new HashMap<String, DelegatingValueProvider>();
                this.refreshValueProviders();
            }
            return this.valueProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshValueProviders() {
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        List providers = e == null ? dm.lookup(null, ValueProvider.class) : DebuggerManager.join((ContextProvider)e, (ContextProvider)dm).lookup(null, ValueProvider.class);
        if (!providers.isEmpty()) {
            Object object = this.valueProvidersLock;
            synchronized (object) {
                if (this.valueProviders == null) {
                    this.valueProviders = new HashMap<String, DelegatingValueProvider>();
                }
                HashSet<String> existingProviderIds = new HashSet<String>();
                for (ValueProvider provider : providers) {
                    String id = provider.getId();
                    existingProviderIds.add(id);
                    DelegatingValueProvider dvp = this.valueProviders.get(id);
                    if (dvp == null) {
                        dvp = new DelegatingValueProvider(id);
                        this.valueProviders.put(id, dvp);
                    }
                    dvp.setDelegate(provider);
                }
                HashSet<String> staleProviderIds = new HashSet<String>(this.valueProviders.keySet());
                staleProviderIds.removeAll(existingProviderIds);
                for (String staleId : staleProviderIds) {
                    this.valueProviders.get(staleId).setDelegate(null);
                }
            }
        }
    }

    private static final class DelegatingValueProvider
    implements ValueProvider {
        private final String id;
        private volatile ValueProvider delegate;
        private final Map<Watch, ValueProvider.ValueChangeListener> listeners = new HashMap<Watch, ValueProvider.ValueChangeListener>();

        DelegatingValueProvider(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getValue(Watch watch) {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                return vp.getValue(watch);
            }
            return null;
        }

        @Override
        public String getEvaluatingText() {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                return vp.getEvaluatingText();
            }
            return ValueProvider.super.getEvaluatingText();
        }

        @Override
        public String getEditableValue(Watch watch) {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                return vp.getEditableValue(watch);
            }
            return ValueProvider.super.getEditableValue(watch);
        }

        @Override
        public boolean setValue(Watch watch, String value) {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                return vp.setValue(watch, value);
            }
            return ValueProvider.super.setValue(watch, value);
        }

        @Override
        public Action[] getHeadActions(Watch watch) {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                return vp.getHeadActions(watch);
            }
            return ValueProvider.super.getHeadActions(watch);
        }

        @Override
        public Action[] getTailActions(Watch watch) {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                return vp.getTailActions(watch);
            }
            return ValueProvider.super.getTailActions(watch);
        }

        @Override
        public synchronized void setChangeListener(Watch watch, ValueProvider.ValueChangeListener chl) {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                vp.setChangeListener(watch, chl);
            }
            this.listeners.put(watch, chl);
        }

        @Override
        public synchronized void unsetChangeListener(Watch watch) {
            ValueProvider vp = this.delegate;
            if (vp != null) {
                vp.unsetChangeListener(watch);
            }
            this.listeners.remove(watch);
        }

        synchronized void setDelegate(ValueProvider delegate) {
            this.delegate = delegate;
            if (delegate == null) {
                for (Map.Entry<Watch, ValueProvider.ValueChangeListener> wvl : this.listeners.entrySet()) {
                    wvl.getValue().valueChanged(wvl.getKey());
                }
            } else {
                for (Map.Entry<Watch, ValueProvider.ValueChangeListener> wvl : this.listeners.entrySet()) {
                    delegate.setChangeListener(wvl.getKey(), wvl.getValue());
                }
            }
        }
    }

    public static interface ValueProvider {
        public String getId();

        public String getValue(Watch var1);

        default public String getEvaluatingText() {
            return Bundle.WATCH_EVALUATING();
        }

        default public String getEditableValue(Watch watch) {
            return null;
        }

        default public boolean setValue(Watch watch, String value) {
            throw new UnsupportedOperationException("Watch not editable.");
        }

        default public Action[] getHeadActions(Watch watch) {
            return null;
        }

        default public Action[] getTailActions(Watch watch) {
            return null;
        }

        public void setChangeListener(Watch var1, ValueChangeListener var2);

        public void unsetChangeListener(Watch var1);

        public static interface ValueChangeListener {
            public void valueChanged(Watch var1);
        }
    }
}

