/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey;

import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.jersey.JerseyHttpRequest;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;

final class JerseyHttpClient
implements HttpClient {
    final List<RequestInterceptor> requestInterceptors;
    private final WebTarget baseTarget;
    final Client client;
    final boolean isApacheNonBufferingClient;

    JerseyHttpClient(Client client, WebTarget baseTarget, List<RequestInterceptor> requestInterceptors, boolean isApacheNonBufferingClient) {
        this.client = client;
        this.baseTarget = baseTarget;
        this.requestInterceptors = requestInterceptors;
        this.isApacheNonBufferingClient = isApacheNonBufferingClient;
    }

    public HttpRequest createRequest(Method method) {
        return new JerseyHttpRequest(this, method, this.baseTarget);
    }

    public void close() {
        this.client.close();
    }

    public boolean isProcessingException(Exception e) {
        return e instanceof ProcessingException;
    }
}

