/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.management;

import java.lang.reflect.Method;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.management.ExecutionEvent;
import org.graalvm.polyglot.management.ExecutionListener;

final class Management {
    static final ManagementAccessImpl ACCESS = new ManagementAccessImpl();

    private Management() {
    }

    private static final class ManagementAccessImpl
    extends AbstractPolyglotImpl.ManagementAccess {
        private ManagementAccessImpl() {
        }

        @Override
        public Object newExecutionListener(AbstractPolyglotImpl.AbstractExecutionListenerDispatch dispatch, Object receiver) {
            return new ExecutionListener(dispatch, receiver);
        }

        @Override
        public Object newExecutionEvent(AbstractPolyglotImpl.AbstractExecutionEventDispatch dispatch, Object event) {
            return new ExecutionEvent(dispatch, event);
        }

        @Override
        public Object getExecutionListenerReceiver(Object executionListener) {
            return ((ExecutionListener)executionListener).receiver;
        }

        @Override
        public AbstractPolyglotImpl.AbstractExecutionListenerDispatch getExecutionListenerDispatch(Object executionListener) {
            return ((ExecutionListener)executionListener).dispatch;
        }

        @Override
        public Object getExecutionEventReceiver(Object executionEvent) {
            return ((ExecutionEvent)executionEvent).receiver;
        }

        @Override
        public AbstractPolyglotImpl.AbstractExecutionEventDispatch getExecutionEventDispatch(Object executionEvent) {
            return ((ExecutionEvent)executionEvent).dispatch;
        }
    }

    static class ImplHolder {
        static final AbstractPolyglotImpl IMPL = ImplHolder.initImpl();

        ImplHolder() {
        }

        private static AbstractPolyglotImpl initImpl() {
            try {
                Method method = Engine.class.getDeclaredMethod("getImpl", new Class[0]);
                method.setAccessible(true);
                AbstractPolyglotImpl impl = (AbstractPolyglotImpl)method.invoke(null, new Object[0]);
                return impl;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initialize execution listener class.", e);
            }
        }
    }
}

