/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalBackupJob
extends ExplicitlySetBmcModel {
    @JsonProperty(value="backupId")
    private final String backupId;
    @JsonProperty(value="provisioning")
    private final Boolean provisioning;
    @JsonProperty(value="swiftPath")
    private final String swiftPath;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="tag")
    private final String tag;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="swiftPassword")
    private final String swiftPassword;

    @Deprecated
    @ConstructorProperties(value={"backupId", "provisioning", "swiftPath", "bucketName", "tag", "userName", "swiftPassword"})
    public ExternalBackupJob(String backupId, Boolean provisioning, String swiftPath, String bucketName, String tag, String userName, String swiftPassword) {
        this.backupId = backupId;
        this.provisioning = provisioning;
        this.swiftPath = swiftPath;
        this.bucketName = bucketName;
        this.tag = tag;
        this.userName = userName;
        this.swiftPassword = swiftPassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBackupId() {
        return this.backupId;
    }

    public Boolean getProvisioning() {
        return this.provisioning;
    }

    public String getSwiftPath() {
        return this.swiftPath;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getTag() {
        return this.tag;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSwiftPassword() {
        return this.swiftPassword;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalBackupJob(");
        sb.append("super=").append(super.toString());
        sb.append("backupId=").append(String.valueOf(this.backupId));
        sb.append(", provisioning=").append(String.valueOf(this.provisioning));
        sb.append(", swiftPath=").append(String.valueOf(this.swiftPath));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", tag=").append(String.valueOf(this.tag));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", swiftPassword=").append(String.valueOf(this.swiftPassword));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalBackupJob)) {
            return false;
        }
        ExternalBackupJob other = (ExternalBackupJob)((Object)o);
        return Objects.equals(this.backupId, other.backupId) && Objects.equals(this.provisioning, other.provisioning) && Objects.equals(this.swiftPath, other.swiftPath) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.tag, other.tag) && Objects.equals(this.userName, other.userName) && Objects.equals(this.swiftPassword, other.swiftPassword) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.backupId == null ? 43 : this.backupId.hashCode());
        result = result * 59 + (this.provisioning == null ? 43 : this.provisioning.hashCode());
        result = result * 59 + (this.swiftPath == null ? 43 : this.swiftPath.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.tag == null ? 43 : this.tag.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.swiftPassword == null ? 43 : this.swiftPassword.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="backupId")
        private String backupId;
        @JsonProperty(value="provisioning")
        private Boolean provisioning;
        @JsonProperty(value="swiftPath")
        private String swiftPath;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="tag")
        private String tag;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="swiftPassword")
        private String swiftPassword;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder backupId(String backupId) {
            this.backupId = backupId;
            this.__explicitlySet__.add("backupId");
            return this;
        }

        public Builder provisioning(Boolean provisioning) {
            this.provisioning = provisioning;
            this.__explicitlySet__.add("provisioning");
            return this;
        }

        public Builder swiftPath(String swiftPath) {
            this.swiftPath = swiftPath;
            this.__explicitlySet__.add("swiftPath");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            this.__explicitlySet__.add("tag");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder swiftPassword(String swiftPassword) {
            this.swiftPassword = swiftPassword;
            this.__explicitlySet__.add("swiftPassword");
            return this;
        }

        public ExternalBackupJob build() {
            ExternalBackupJob model = new ExternalBackupJob(this.backupId, this.provisioning, this.swiftPath, this.bucketName, this.tag, this.userName, this.swiftPassword);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalBackupJob model) {
            if (model.wasPropertyExplicitlySet("backupId")) {
                this.backupId(model.getBackupId());
            }
            if (model.wasPropertyExplicitlySet("provisioning")) {
                this.provisioning(model.getProvisioning());
            }
            if (model.wasPropertyExplicitlySet("swiftPath")) {
                this.swiftPath(model.getSwiftPath());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("tag")) {
                this.tag(model.getTag());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("swiftPassword")) {
                this.swiftPassword(model.getSwiftPassword());
            }
            return this;
        }
    }
}

