/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDatabaseRequest
extends BmcRequest<Void> {
    private String databaseId;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseRequest)) {
            return false;
        }
        GetDatabaseRequest other = (GetDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseRequest build() {
            GetDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseRequest buildWithoutInvocationCallback() {
            GetDatabaseRequest request = new GetDatabaseRequest();
            request.databaseId = this.databaseId;
            return request;
        }
    }
}

