/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.modules.java.lsp.server.LspGsonSetup;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChange;
import org.netbeans.modules.project.dependency.DependencyChangeRequest;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;

public class ExtraGsonSetup
implements LspGsonSetup {
    private static final Set<String> ARTIFACT_BLOCK_FIELDS = new HashSet<String>(Arrays.asList("data"));
    private static final Set<String> DEPENDENCY_BLOCK_FIELDS = new HashSet<String>(Arrays.asList("parent", "data"));

    public void configureBuilder(GsonBuilder b) {
        b.addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fa) {
                if (fa.getDeclaringClass() == ArtifactSpec.class) {
                    return ARTIFACT_BLOCK_FIELDS.contains(fa.getName());
                }
                if (Throwable.class.isAssignableFrom(fa.getDeclaredClass())) {
                    return DEPENDENCY_BLOCK_FIELDS.contains(fa.getName());
                }
                if (fa.getDeclaringClass() == Dependency.class) {
                    // empty if block
                }
                return false;
            }

            public boolean shouldSkipClass(Class<?> type) {
                return false;
            }
        });
        b.registerTypeAdapter(ArtifactSpec.class, (Object)new ArtifactDeserializer());
        b.registerTypeAdapter(Scope.class, (Object)new ScopeSerializer());
        b.registerTypeAdapter(Dependency.class, (Object)new DependencySerializer());
        b.registerTypeAdapter(DependencyChangeRequest.class, t -> new DependencyChangeRequest(Collections.emptyList()));
        b.registerTypeAdapter(DependencyChange.class, t -> DependencyChange.builder((DependencyChange.Kind)DependencyChange.Kind.ADD).create());
        b.registerTypeAdapterFactory((TypeAdapterFactory)new LowercaseEnumTypeAdapterFactory());
    }

    private static ArtifactSpec deserializeArtifactFromString(String s) {
        String[] parts;
        boolean snap;
        int scopeIndex = s.lastIndexOf(91);
        if (scopeIndex > -1) {
            s = s.substring(0, scopeIndex);
        }
        boolean bl = snap = (parts = s.split(":")).length > 2 && parts[2].endsWith("-SNAPSHOT");
        if (snap) {
            return ArtifactSpec.createSnapshotSpec((String)parts[0], (String)parts[1], null, (String)(parts.length > 3 ? parts[3] : null), (String)(parts.length > 2 ? parts[2] : null), (boolean)false, null, null);
        }
        return ArtifactSpec.createVersionSpec((String)parts[0], (String)parts[1], null, (String)(parts.length > 3 ? parts[3] : null), (String)(parts.length > 2 ? parts[2] : null), (boolean)false, null, null);
    }

    class ArtifactDeserializer
    implements JsonDeserializer<ArtifactSpec> {
        ArtifactDeserializer() {
        }

        public ArtifactSpec deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            if (je.isJsonNull()) {
                return null;
            }
            if (je.isJsonPrimitive()) {
                return ExtraGsonSetup.deserializeArtifactFromString(je.getAsString());
            }
            if (!je.isJsonObject()) {
                throw new JsonParseException("Expected artifact string or structure");
            }
            JsonObject obj = je.getAsJsonObject();
            String g = obj.has("groupId") ? obj.getAsJsonPrimitive("groupId").getAsString() : null;
            String a = obj.has("artifactId") ? obj.getAsJsonPrimitive("artifactId").getAsString() : null;
            String v = obj.has("versionSpec") ? obj.getAsJsonPrimitive("versionSpec").getAsString() : null;
            String c = obj.has("classifier") ? obj.getAsJsonPrimitive("classifier").getAsString() : null;
            String t = obj.has("type") ? obj.getAsJsonPrimitive("type").getAsString() : null;
            ArtifactSpec.Builder b = ArtifactSpec.builder((String)g, (String)a, (String)v, null).classifier(c).type(t);
            if (v != null && v.contains("-SNAPSHOT")) {
                b.versionKind(ArtifactSpec.VersionKind.SNAPSHOT);
            }
            return b.build();
        }
    }

    public class ScopeSerializer
    implements JsonDeserializer<Scope>,
    JsonSerializer<Scope> {
        public Scope deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            return Scope.named((String)je.getAsString());
        }

        public JsonElement serialize(Scope t, Type type, JsonSerializationContext jsc) {
            return jsc.serialize((Object)t.name());
        }
    }

    static class DependencySerializer
    implements JsonDeserializer<Dependency> {
        private static final Type DEPENDENCY_LIST_TYPE = new TypeToken<List<Dependency>>(){}.getType();

        DependencySerializer() {
        }

        public Dependency deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            Scope scope = Scopes.COMPILE;
            if (je.isJsonNull()) {
                return null;
            }
            if (je.isJsonPrimitive()) {
                String s = je.getAsString();
                int scopeIndex = s.lastIndexOf(91);
                if (scopeIndex > -1) {
                    int end = s.indexOf(93, scopeIndex);
                    if (end == -1) {
                        end = s.length();
                    }
                    scope = Scope.named((String)s.substring(scopeIndex, end));
                    s = s.substring(0, scopeIndex);
                }
                ArtifactSpec a = ExtraGsonSetup.deserializeArtifactFromString(s);
                return Dependency.make((ArtifactSpec)a, (Scope)scope);
            }
            if (!je.isJsonObject()) {
                throw new JsonParseException("Expected dependency string or structure");
            }
            JsonObject o = je.getAsJsonObject();
            ArtifactSpec a = (ArtifactSpec)jdc.deserialize(o.get("artifact"), ArtifactSpec.class);
            List children = new ArrayList();
            if (o.has("scope")) {
                scope = (Scope)jdc.deserialize(o.get("scope"), Scope.class);
            }
            if (o.has("children")) {
                children = (List)jdc.deserialize((JsonElement)o.getAsJsonArray("children"), DEPENDENCY_LIST_TYPE);
            }
            return Dependency.create((ArtifactSpec)a, (Scope)scope, children, null);
        }
    }

    public class LowercaseEnumTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (!rawType.isEnum() || !type.getType().getTypeName().startsWith("org.netbeans.modules.project.dependency")) {
                return null;
            }
            final HashMap lowercaseToConstant = new HashMap();
            for (Object constant : rawType.getEnumConstants()) {
                lowercaseToConstant.put(this.toLowercase(constant), constant);
            }
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    if (value == null) {
                        out.nullValue();
                    } else {
                        out.value(value.toString());
                    }
                }

                public T read(JsonReader reader) throws IOException {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    return lowercaseToConstant.get(LowercaseEnumTypeAdapterFactory.this.toLowercase(reader.nextString()));
                }
            };
        }

        private String toLowercase(Object o) {
            return o.toString().toLowerCase(Locale.US);
        }
    }

    class DependencyChangeDeserializer
    implements JsonDeserializer<DependencyChange> {
        private final Type OPTION_SET_TYPE = new TypeToken<EnumSet<DependencyChange.Options>>(){}.getType();

        DependencyChangeDeserializer() {
        }

        public DependencyChange deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            if (je.isJsonNull()) {
                return null;
            }
            if (!je.isJsonObject()) {
                throw new JsonParseException("Expected DependencyChange structure");
            }
            JsonObject o = je.getAsJsonObject();
            DependencyChange.Kind kind = (DependencyChange.Kind)jdc.deserialize((JsonElement)o.getAsJsonPrimitive("kind"), DependencyChange.Kind.class);
            EnumSet opts = (EnumSet)jdc.deserialize((JsonElement)o.getAsJsonPrimitive("kind"), this.OPTION_SET_TYPE);
            return null;
        }
    }
}

