/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration;

import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.k8s.ClusterItem;
import org.netbeans.modules.cloud.oracle.bucket.BucketItem;
import org.netbeans.modules.cloud.oracle.compute.ComputeInstanceItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerTagItem;
import org.netbeans.modules.cloud.oracle.items.ContextValuesProvider;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.vault.SecretItem;
import org.netbeans.modules.java.lsp.server.explorer.NodeLookupContextValues;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataListener;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeItemData;
import org.openide.nodes.Node;

public class LspAssetsDecorationProvider
implements TreeDataProvider.Factory {
    private static final Logger LOG = Logger.getLogger(LspAssetsDecorationProvider.class.getName());
    public static final String CTXVALUE_CAP_REFERENCE_NAME = "cap:refName";
    public static final String CTXVALUE_PREFIX_REFERENCE_NAME = "cloudAssetsReferenceName:";
    public static final String CTXVALUE_PREFIX_PUBLIC_IP = "publicIp:";
    public static final String CTXVALUE_PREFIX_CLUSTER_NAME = "clusterName:";
    public static final String CTXVALUE_PREFIX_IMAGE_URL = "imageUrl:";
    public static final String CTXVALUE_PREFIX_IMAGE_COUNT = "imageCount:";
    public static final String CTXVALUE_PREFIX_REPOSITORY_PUBLIC = "repositoryPublic:";
    public static final String CTXVALUE_PREFIX_SECRET_LIFECYCLE_STATE = "lifecycleState:";
    public static final String CTXVALUE_PREFIX_CLUSTER_NAMESPACE = "clusterNamespace:";
    public static final String CTXVALUE_PREFIX_CONSOLE_URL = "consoleUrl:";
    public static final String CTXVALUE_PREFIX_PORT_FORWARD_URL = "portForward:";

    public synchronized TreeDataProvider createProvider(String treeId) {
        return new ProviderImpl(null);
    }

    static class ProviderImpl
    implements TreeDataProvider {
        public ProviderImpl(NodeLookupContextValues lookupValues) {
        }

        public TreeItemData createDecorations(Node n, boolean expanded) {
            ContextValuesProvider context;
            TreeItemData d = new TreeItemData();
            boolean set = false;
            OCIItem item = (OCIItem)n.getLookup().lookup(OCIItem.class);
            if (item != null) {
                String publicIp;
                String namespace;
                String refName;
                URL consoleURL;
                if (item instanceof URLProvider && (consoleURL = ((URLProvider)item).getURL()) != null) {
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_CONSOLE_URL + consoleURL.toExternalForm()});
                    set = true;
                }
                if ((refName = CloudAssets.getDefault().getReferenceName(item)) != null) {
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_REFERENCE_NAME + refName});
                    set = true;
                }
                if (item instanceof ClusterItem && (namespace = ((ClusterItem)item).getNamespace()) != null) {
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_CLUSTER_NAMESPACE + namespace});
                    set = true;
                }
                if (item instanceof ComputeInstanceItem && (publicIp = ((ComputeInstanceItem)item).getPublicIp()) != null) {
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_PUBLIC_IP + publicIp});
                    set = true;
                }
                if (item instanceof ContainerRepositoryItem) {
                    ContainerRepositoryItem repo = (ContainerRepositoryItem)item;
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_IMAGE_COUNT + repo.getImageCount()});
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_REPOSITORY_PUBLIC + repo.getIsPublic()});
                    set = true;
                }
                if (item instanceof ContainerTagItem) {
                    String imageUrl = ((ContainerTagItem)item).getUrl();
                    Optional<OCIItem> instance = CloudAssets.getDefault().getAssignedItems().stream().filter(i -> i.getClass().equals(ComputeInstanceItem.class)).findFirst();
                    if (instance.isPresent()) {
                        d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_PUBLIC_IP + ((ComputeInstanceItem)instance.get()).getPublicIp()});
                    } else {
                        ClusterItem cluster = (ClusterItem)CloudAssets.getDefault().getItem(ClusterItem.class);
                        if (cluster != null) {
                            d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_CLUSTER_NAME + cluster.getName()});
                        }
                    }
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_IMAGE_URL + imageUrl});
                    set = true;
                }
                if (item instanceof BucketItem || item instanceof DatabaseItem) {
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_CAP_REFERENCE_NAME});
                    set = true;
                }
                if (item instanceof SecretItem) {
                    d.addContextValues(new String[]{LspAssetsDecorationProvider.CTXVALUE_PREFIX_SECRET_LIFECYCLE_STATE + ((SecretItem)item).getLifecycleState()});
                    set = true;
                }
            }
            if ((context = (ContextValuesProvider)n.getLookup().lookup(ContextValuesProvider.class)) != null) {
                for (Map.Entry entry : context.getContextValues().entrySet()) {
                    d.addContextValues(new String[]{(String)entry.getKey() + ":" + (String)entry.getValue()});
                }
                set = true;
            }
            return set ? d : null;
        }

        public void addTreeItemDataListener(TreeDataListener l) {
        }

        public void removeTreeItemDataListener(TreeDataListener l) {
        }

        public void nodeReleased(Node n) {
        }
    }
}

