/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration;

import java.awt.EventQueue;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class UIDefaultsIconMetadata
implements Runnable {
    private static final Logger LOG = Logger.getLogger(UIDefaultsIconMetadata.class.getName());
    private static final String RESOURCE_PREFIX = "org/netbeans/modules/nbcode/integration/resources/uidefaults/";

    @Override
    public void run() {
        EventQueue.invokeLater(() -> {
            UIManager.get("force.laf.initialization");
            ImageUtilities.loadImage((String)"org/netbeans/modules/nbcode/integration/resources/empty.png");
            UIDefaultsIconMetadata.replaceIconsAndImages(UIManager.getDefaults());
        });
    }

    static void replaceIconsAndImages(UIDefaults defs) {
        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try (InputStream is = UIDefaultsIconMetadata.class.getResourceAsStream("resources/uimanager-icons.properties");){
            Properties p = new Properties();
            p.load(is);
            Set entries = defs.entrySet();
            HashSet uiDefaultsKeys = new HashSet();
            for (Map.Entry e : entries) {
                uiDefaultsKeys.add(e.getKey());
            }
            for (String uiKey : p.stringPropertyNames()) {
                String resImage;
                if (!uiDefaultsKeys.contains(uiKey)) {
                    LOG.log(Level.INFO, "Icon not used: {0}", uiKey);
                    continue;
                }
                String v = p.getProperty(uiKey);
                URL u = null;
                if (v == null || v.trim().isEmpty()) {
                    String r = RESOURCE_PREFIX + uiKey + ".png";
                    u = l.getResource(r);
                    if (u == null) {
                        r = RESOURCE_PREFIX + uiKey + ".gif";
                    }
                    resImage = r;
                } else {
                    resImage = v;
                    u = l.getResource(resImage);
                }
                if (u == null) {
                    LOG.log(Level.WARNING, "Resource missing: {0}", resImage);
                    continue;
                }
                LOG.log(Level.INFO, "Lazy-replacing icon: {0}", uiKey);
                defs.put(uiKey, new UIDefaults.LazyValue(){

                    @Override
                    public Object createValue(UIDefaults table) {
                        return ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)resImage));
                    }
                });
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not load image replacements", ex);
        }
    }
}

