/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration.commands;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.adm.AuditOptions;
import org.netbeans.modules.cloud.oracle.adm.AuditResult;
import org.netbeans.modules.cloud.oracle.adm.ProjectVulnerability;
import org.netbeans.modules.java.lsp.server.protocol.UIContext;
import org.netbeans.modules.nbcode.integration.commands.Bundle;
import org.netbeans.modules.nbcode.integration.commands.Utils;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ProjectAuditCommand
implements CommandProvider {
    private static final Logger LOG = Logger.getLogger(ProjectAuditCommand.class.getName());
    private static final String COMMAND_EXECUTE_AUDIT = "nbls.projectAudit.execute";
    private static final String COMMAND_EXECUTE_AUDIT_OLD = "nbls.gcn.projectAudit.execute";
    private static final String COMMAND_LOAD_AUDIT = "nbls.projectAudit.display";
    private static final String COMMAND_LOAD_AUDIT_OLD = "nbls.gcn.projectAudit.display";
    public static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("nbls.projectAudit.execute", "nbls.projectAudit.display", "nbls.gcn.projectAudit.execute", "nbls.gcn.projectAudit.display"));
    private final Gson gson = new Gson();

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        OCIProfile auditWithProfile;
        String preferredName;
        Object o;
        if (arguments.size() < 3) {
            throw new IllegalArgumentException("Expected 3 parameters: resource, compartment, knowledgebase");
        }
        FileObject f = Utils.extractFileObject(arguments.get(0), this.gson);
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        if (p == null) {
            throw new IllegalArgumentException("Not part of a project " + f);
        }
        ProjectVulnerability v = (ProjectVulnerability)p.getLookup().lookup(ProjectVulnerability.class);
        ProjectInformation pi = ProjectUtils.getInformation((Project)p);
        String n = pi.getDisplayName();
        if (n == null) {
            n = pi.getName();
        }
        if (n == null) {
            n = p.getProjectDirectory().getName();
        }
        String fn = n;
        if (v == null) {
            throw new IllegalArgumentException("Project " + n + " does not support vulnerability audits");
        }
        if (arguments.size() < 3 || !(arguments.get(1) instanceof JsonPrimitive)) {
            throw new IllegalArgumentException("Expected 3 parameters: resource, knowledgebase, options");
        }
        String knowledgeBase = ((JsonPrimitive)arguments.get(1)).getAsString();
        Object object = o = arguments.size() > 2 ? arguments.get(2) : new JsonObject();
        if (!(o instanceof JsonObject)) {
            throw new IllegalArgumentException("Expected structure, got  " + o);
        }
        Object options = o;
        UIContext ctx = (UIContext)Lookup.getDefault().lookup(UIContext.class);
        LOG.log(Level.FINE, "Running audit command with context: {0}", ctx);
        boolean forceAudit = options.has("force") && options.get("force").getAsBoolean();
        boolean executeIfNotExists = forceAudit || !options.has("compute") || options.get("compute").getAsBoolean();
        boolean disableCache = forceAudit || options.has("disableCache") && options.get("disableCache").getAsBoolean();
        String string = preferredName = options.has("auditName") ? options.get("auditName").getAsString() : null;
        if (options.has("profile")) {
            String id = options.get("profile").getAsString();
            Path path = options.has("configPath") ? Paths.get(options.get("configPath").getAsString(), new String[0]) : null;
            auditWithProfile = OCIManager.forConfig(path, (String)id);
        } else {
            auditWithProfile = OCIManager.getDefault().getActiveProfile();
        }
        AuditOptions auditOpts = AuditOptions.makeNewAudit().useSession((OCISessionInitiator)auditWithProfile).setAuditName(preferredName);
        if (options.has("returnData") && options.get("returnData").isJsonPrimitive()) {
            auditOpts.setReturnData(options.getAsJsonPrimitive("returnData").getAsBoolean());
        }
        if (options.has("displaySummary") && options.get("displaySummary").isJsonPrimitive()) {
            auditOpts.setDisplaySummary(options.getAsJsonPrimitive("displaySummary").getAsBoolean());
        }
        if (options.has("suppressErrors") && options.get("suppressErrors").isJsonPrimitive()) {
            auditOpts.setSupressErrors(options.getAsJsonPrimitive("suppressErrors").getAsBoolean());
        }
        AuditResult[] refR = new AuditResult[]{null};
        Throwable[] exc = new Throwable[]{null};
        return (CompletableFuture)OCIManager.usingSession((OCISessionInitiator)auditWithProfile, () -> ((CompletableFuture)v.findKnowledgeBase(knowledgeBase).exceptionally(th -> {
            if (!auditOpts.isSupressErrors()) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_KnowledgeBaseSearchFailed(fn, th.getMessage()), 0));
            } else {
                exc[0] = th;
            }
            return null;
        })).thenCompose(kb -> {
            CompletableFuture exec;
            if (exc[0] != null) {
                CompletableFuture r2 = new CompletableFuture();
                r2.completeExceptionally(exc[0]);
                return r2;
            }
            if (kb == null) {
                return CompletableFuture.completedFuture(refR[0]);
            }
            switch (command) {
                case "nbls.projectAudit.execute": 
                case "nbls.gcn.projectAudit.execute": {
                    exec = v.runProjectAudit(kb, auditOpts);
                    break;
                }
                case "nbls.projectAudit.display": 
                case "nbls.gcn.projectAudit.display": {
                    exec = v.runProjectAudit(kb, auditOpts.setRunIfNotExists(executeIfNotExists).setForceAuditExecution(forceAudit).setDisableCache(disableCache));
                    break;
                }
                default: {
                    return CompletableFuture.completedFuture(null);
                }
            }
            if (auditOpts.isReturnData()) {
                return exec.thenApply(r -> r);
            }
            return exec.thenApply(r -> r.getAuditId());
        }));
    }

    public Set<String> getCommands() {
        return COMMANDS;
    }
}

