/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration.commands;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.LspServerUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.SaveDocumentRequestParams;
import org.netbeans.modules.nbcode.integration.commands.Bundle;
import org.netbeans.modules.nbcode.integration.commands.DependencyFindRequest;
import org.netbeans.modules.nbcode.integration.commands.DependencyFindResult;
import org.netbeans.modules.nbcode.integration.commands.LspDependencyChangeRequest;
import org.netbeans.modules.nbcode.integration.commands.LspDependencyChangeResult;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChangeException;
import org.netbeans.modules.project.dependency.DependencyChangeRequest;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectModificationResult;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ProjectDependenciesCommand
implements CommandProvider {
    private static final RequestProcessor RP = new RequestProcessor(ProjectDependenciesCommand.class.getName(), 5);
    private static final String COMMAND_GET_DEPENDENCIES = "nbls.project.dependencies.find";
    private static final String COMMAND_CHANGE_DEPENDENCIES = "nbls.project.dependencies.change";
    private static final Set COMMANDS = new HashSet<String>(Arrays.asList("nbls.project.dependencies.find", "nbls.project.dependencies.change"));
    private final Gson gson = new Gson();

    public Set<String> getCommands() {
        return COMMANDS;
    }

    private Gson gson() {
        Gson inst = (Gson)Lookup.getDefault().lookup(Gson.class);
        return inst != null ? inst : this.gson;
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        switch (command) {
            case "nbls.project.dependencies.find": {
                FileObject dir;
                DependencyFindRequest request = (DependencyFindRequest)this.gson().fromJson(this.gson().toJson(arguments.get(0)), DependencyFindRequest.class);
                try {
                    dir = Utils.fromUri((String)request.getUri());
                }
                catch (MalformedURLException ex) {
                    CompletableFuture<Object> res = new CompletableFuture<Object>();
                    res.completeExceptionally(ex);
                    return res;
                }
                if (dir == null) {
                    throw new IllegalArgumentException("Not a file");
                }
                Project p = FileOwnerQuery.getOwner((FileObject)dir);
                if (p == null) {
                    return CompletableFuture.completedFuture(null);
                }
                List<ArtifactSpec> matches = request.getArtifacts();
                Scope[] scopes = request.getScopes() == null ? null : (Scope[])request.getScopes().stream().map(sn -> Scope.named((String)sn)).toArray(Scope[]::new);
                ProjectDependencies.DependencyQueryBuilder b = ProjectDependencies.newBuilder().online().scope(scopes);
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                RP.post(() -> {
                    DependencyResult r;
                    try {
                        r = ProjectDependencies.findDependencies((Project)p, (ProjectDependencies.DependencyQuery)b.build());
                    }
                    catch (ProjectOperationException ex) {
                        future.completeExceptionally(ex);
                        return;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                        return;
                    }
                    DependencyFindResult res = new DependencyFindResult();
                    res.setUri(URLMapper.findURL((FileObject)p.getProjectDirectory(), (int)1).toString());
                    res.setProject(r.getRoot().getArtifact());
                    ArrayDeque toProcess = new ArrayDeque();
                    ArrayList<Dependency> accepted = new ArrayList<Dependency>();
                    toProcess.addAll(r.getRoot().getChildren());
                    HashSet<K> seen = new HashSet<K>();
                    while (!toProcess.isEmpty()) {
                        Dependency d = (Dependency)toProcess.poll();
                        ArtifactSpec a = d.getArtifact();
                        if (a == null || !seen.add(new K(d))) continue;
                        toProcess.addAll(d.getChildren());
                        boolean found = false;
                        if (matches != null && !matches.isEmpty()) {
                            for (ArtifactSpec test : matches) {
                                if (test.getGroupId() != null && !test.getGroupId().equals(a.getGroupId()) || test.getArtifactId() != null && !test.getArtifactId().equals(a.getArtifactId()) || test.getVersionSpec() != null && !test.getVersionSpec().equals(a.getVersionSpec()) || test.getClassifier() != null && !test.getClassifier().equals(a.getClassifier()) || test.getType() != null && !test.getType().equals(a.getType())) continue;
                                found = true;
                                break;
                            }
                        } else {
                            found = true;
                        }
                        if (!found) continue;
                        if (request.isReturnContents()) {
                            accepted.add(d);
                            continue;
                        }
                        accepted.add(Dependency.create((ArtifactSpec)a, (Scope)d.getScope(), Collections.emptyList(), null));
                    }
                    res.setMatches(accepted);
                    future.complete(res);
                });
                return future;
            }
            case "nbls.project.dependencies.change": {
                Project p;
                LspDependencyChangeRequest request = (LspDependencyChangeRequest)this.gson().fromJson(this.gson().toJson(arguments.get(0)), LspDependencyChangeRequest.class);
                try {
                    FileObject dir = Utils.fromUri((String)request.getUri());
                    p = FileOwnerQuery.getOwner((FileObject)dir);
                    if (p == null) {
                        throw new IllegalArgumentException(Bundle.ERR_FileNotInProject(request.getUri()));
                    }
                }
                catch (MalformedURLException ex) {
                    throw new IllegalArgumentException(Bundle.ERR_InvalidFileUri(request.getUri()));
                }
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                RP.post(() -> {
                    ProjectModificationResult mod;
                    LspDependencyChangeResult res = new LspDependencyChangeResult();
                    try {
                        mod = ProjectDependencies.modifyDependencies((Project)p, (DependencyChangeRequest)request.getChanges());
                    }
                    catch (DependencyChangeException ex) {
                        future.completeExceptionally(ex);
                        return;
                    }
                    if (mod == null) {
                        future.complete(null);
                        return;
                    }
                    NbCodeLanguageClient client = LspServerUtils.requireLspClient((Lookup)Lookup.getDefault());
                    WorkspaceEdit wEdit = mod.getWorkspaceEdit();
                    org.eclipse.lsp4j.WorkspaceEdit lspEdit = Utils.workspaceEditFromApi((WorkspaceEdit)wEdit, null, (NbCodeLanguageClient)client);
                    res.setEdit(lspEdit);
                    if (request.isApplyChanges()) {
                        if (request.isSaveFromServer()) {
                            try {
                                mod.commit();
                                future.complete(res);
                            }
                            catch (IOException ex) {
                                future.completeExceptionally(ex);
                            }
                        } else {
                            ((CompletableFuture)((CompletableFuture)client.applyEdit(new ApplyWorkspaceEditParams(lspEdit)).thenApply(x -> {
                                String[] uris = new String[mod.getFilesToSave().size()];
                                int index = 0;
                                for (FileObject f : mod.getFilesToSave()) {
                                    URL u = URLMapper.findURL((FileObject)f, (int)1);
                                    if (u == null) continue;
                                    String s = u.toString();
                                    if (s.indexOf(f.getPath()) == 5) {
                                        s = "file://" + s.substring(5);
                                    }
                                    uris[index++] = s;
                                }
                                return client.requestDocumentSave(new SaveDocumentRequestParams(Arrays.asList(uris)));
                            })).exceptionally(t -> {
                                future.completeExceptionally((Throwable)t);
                                return CompletableFuture.completedFuture(false);
                            })).thenAccept(b -> future.complete(res));
                        }
                    } else {
                        future.complete(res);
                    }
                });
                return future;
            }
        }
        return null;
    }

    static class K {
        final Dependency d;

        public K(Dependency d) {
            this.d = d;
        }

        public int hashCode() {
            return this.d.getArtifact().hashCode() << 7 + this.d.getScope().name().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof K)) {
                return false;
            }
            K other = (K)o;
            return other.d.getArtifact().equals((Object)this.d.getArtifact()) && other.d.getScope().equals((Object)this.d.getScope());
        }
    }
}

