/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectActionContext;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.nbcode.integration.commands.Utils;
import org.netbeans.modules.project.dependency.ProjectArtifactsQuery;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ProjectMetadataCommand
implements CommandProvider {
    private static final String COMMAND_ARTIFACTS = "nbls.project.artifacts";
    private static final String COMMAND_ARTIFACTS_OLD = "nbls.gcn.project.artifacts";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("nbls.project.artifacts", "nbls.gcn.project.artifacts"));
    private static final Set<String> ARTIFACT_BLOCK_FIELDS = new HashSet<String>(Arrays.asList("data"));
    private static final RequestProcessor METADATA_PROCESSOR = new RequestProcessor(ProjectMetadataCommand.class);
    private final Gson gson = new GsonBuilder().create();

    public Set<String> getCommands() {
        return COMMANDS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        Object o;
        if (arguments.size() < 1) {
            throw new IllegalArgumentException("Expected at least project URI/path");
        }
        FileObject f = Utils.extractFileObject(arguments.get(0), this.gson);
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        if (p == null) {
            throw new IllegalArgumentException("Not a project " + f);
        }
        String artifactType = null;
        ProjectActionContext ctx = null;
        String[] tags = null;
        String classifier = null;
        if (arguments.size() > 1) {
            o = arguments.get(1);
            if (o instanceof JsonObject) {
                JsonElement t;
                JsonObject request = (JsonObject)o;
                if (request.has("action")) {
                    JsonElement a = request.get("action");
                    if (!(a instanceof JsonPrimitive)) throw new IllegalArgumentException("String expected as action, got " + a);
                    ctx = ProjectActionContext.newBuilder((Project)p).forProjectAction(((JsonPrimitive)a).getAsString()).context();
                }
                if (request.has("type")) {
                    t = request.get("type");
                    if (!(t instanceof JsonPrimitive)) throw new IllegalArgumentException("String expected as type, got " + t);
                    artifactType = ((JsonPrimitive)t).getAsString();
                }
                if (request.has("classifier")) {
                    JsonElement c = request.get("classifier");
                    if (!(c instanceof JsonPrimitive)) throw new IllegalArgumentException("String expected as classifier, got " + c);
                    classifier = ((JsonPrimitive)c).getAsString();
                }
                if (request.has("tags")) {
                    t = request.get("tags");
                    if (t instanceof JsonPrimitive) {
                        tags = new String[]{((JsonPrimitive)t).getAsString()};
                    } else {
                        if (!(t instanceof JsonArray)) throw new IllegalArgumentException("String or array expected as tags, got " + t);
                        JsonArray arr = (JsonArray)t;
                        tags = new String[arr.size()];
                        int index = 0;
                        for (Object item : arr) {
                            if (!(item instanceof JsonPrimitive)) throw new IllegalArgumentException("String expected as tag, got " + item);
                            tags[index++] = ((JsonPrimitive)item).getAsString();
                        }
                    }
                }
            } else {
                if (!(o instanceof JsonPrimitive)) throw new IllegalArgumentException("String, structure, or null expected as parameter #2, got " + o);
                ctx = ProjectActionContext.newBuilder((Project)p).forProjectAction(((JsonPrimitive)o).getAsString()).context();
            }
        }
        if (arguments.size() > 2) {
            o = arguments.get(2);
            if (!(o instanceof JsonPrimitive)) {
                throw new IllegalArgumentException("String or null expected as parameter #3, got " + o);
            }
            artifactType = ((JsonPrimitive)o).getAsString();
        }
        ProjectArtifactsQuery.Filter filter = ProjectArtifactsQuery.newQuery(artifactType, classifier, ctx, tags);
        return ((LspServerState)Lookup.getDefault().lookup(LspServerState.class)).asyncOpenFileOwner(f).thenApplyAsync(project -> {
            ProjectArtifactsQuery.ArtifactsResult arts = ProjectArtifactsQuery.findArtifacts((Project)p, (ProjectArtifactsQuery.Filter)filter);
            return arts.getArtifacts();
        }, (Executor)METADATA_PROCESSOR);
    }
}

