/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbcode.integration.commands;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

class Utils {
    Utils() {
    }

    static FileObject extractFileObject(Object argument, Gson gson) {
        FileObject f = null;
        String s = "";
        if (argument instanceof JsonPrimitive) {
            s = ((JsonPrimitive)argument).getAsString();
            try {
                URI uri = new URI(s);
                f = URLMapper.findFileObject((URL)uri.toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
                f = FileUtil.toFileObject((File)new File(s));
            }
        } else {
            JsonObject executeOn = (JsonObject)gson.fromJson(gson.toJson(argument), JsonObject.class);
            if (executeOn.has("fsPath")) {
                s = executeOn.get("fsPath").getAsString();
                f = FileUtil.toFileObject((File)new File(s));
            }
        }
        if (f == null) {
            throw new IllegalArgumentException("Invalid path specified: " + s);
        }
        return f;
    }
}

