/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import com.oracle.bmc.Region;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public class MetricsItem
extends OCIItem
implements URLProvider {
    private static final String DEFAULT_AGGREGATION_FUNCTION = "mean()";
    private static final String DEFAULT_INTERVAL = "1m";
    private static final String BASE_URL = "https://cloud.oracle.com/monitoring/explore";
    private static final String DEFAULT_ADVANCED_MODE = "false";
    private static final String DEFAULT_AGGREGATE_METRICS = "false";
    private static final String UTF_8 = "UTF-8";
    private String namespace;
    private String region;

    public MetricsItem() {
    }

    public MetricsItem(String compartmentId, String name, String namespace, Region region, String tenancyId) {
        super(OCID.of("MetricsNamespace/Metrics"), compartmentId, name, tenancyId, region.getRegionCode());
        this.namespace = namespace;
        this.region = region.getRegionId();
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public URL getURL() {
        try {
            String url = this.addQueryTo(BASE_URL);
            return URI.create(url).toURL();
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public String addQueryTo(String baseUrl) throws UnsupportedEncodingException {
        Map<String, String> params = this.getQueryParams();
        StringBuilder sb = new StringBuilder(baseUrl);
        sb.append("?");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(URLEncoder.encode(entry.getKey(), UTF_8)).append("=").append(URLEncoder.encode(entry.getValue(), UTF_8)).append("&");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private Map<String, String> getQueryParams() {
        return new HashMap<String, String>(){
            {
                this.put("panelConfigs[0][advanced]", "false");
                this.put("panelConfigs[0][content][aggregate]", "false");
                this.put("panelConfigs[0][content][compartmentId]", MetricsItem.this.getCompartmentId());
                this.put("panelConfigs[0][content][metricName]", MetricsItem.this.getName());
                this.put("panelConfigs[0][content][namespace]", MetricsItem.this.getNamespace());
                this.put("panelConfigs[0][content][interval]", MetricsItem.DEFAULT_INTERVAL);
                this.put("panelConfigs[0][content][statistic]", MetricsItem.DEFAULT_AGGREGATION_FUNCTION);
                this.put("region", MetricsItem.this.region);
            }
        };
    }
}

