/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import com.oracle.bmc.model.BmcException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.netbeans.modules.cloud.oracle.steps.VaultStep;
import org.netbeans.modules.cloud.oracle.vault.KeyItem;
import org.netbeans.modules.cloud.oracle.vault.KeyNode;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.NotifyDescriptor;

public class KeyStep
extends AbstractStep<KeyItem> {
    private static final Logger LOG = Logger.getLogger(KeyStep.class.getName());
    private Map<String, KeyItem> keys = null;
    private KeyItem selected;
    private VaultItem vault;

    public KeyStep(VaultItem vault) {
        this.vault = vault;
    }

    public KeyStep() {
        this.vault = null;
    }

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        if (this.vault == null) {
            this.vault = (VaultItem)values.getValueForStep(VaultStep.class);
        }
        this.keys = this.getKeys(this.vault);
    }

    @Override
    public boolean onlyOneChoice() {
        return this.keys.size() == 1;
    }

    @Override
    public NotifyDescriptor createInput() {
        if (this.keys.size() > 1) {
            return Steps.createQuickPick(this.keys, Bundle.SelectKey());
        }
        if (this.keys.isEmpty()) {
            return new NotifyDescriptor.QuickPick("", Bundle.NoKeys(), Collections.emptyList(), false);
        }
        throw new IllegalStateException("No data to create input");
    }

    @Override
    public void setValue(String selected) {
        this.selected = this.keys.get(selected);
    }

    @Override
    public KeyItem getValue() {
        if (this.keys.size() == 1) {
            return this.keys.values().iterator().next();
        }
        return this.selected;
    }

    protected Map<String, KeyItem> getKeys(OCIItem parent) {
        HashMap<String, KeyItem> items = new HashMap<String, KeyItem>();
        try {
            if (parent instanceof VaultItem) {
                KeyNode.getKeys().apply((VaultItem)parent).forEach(key -> items.put(key.getName(), (KeyItem)key));
            }
        }
        catch (BmcException e) {
            LOG.log(Level.SEVERE, "Unable to load key list", e);
        }
        return items;
    }
}

