/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RenamePanel
extends JPanel
implements CustomRefactoringPanel {
    private static final Logger LOG = Logger.getLogger(RenamePanel.class.getName());
    private final transient String oldName;
    private final transient ChangeListener parent;
    private final transient TreePathHandle handle;
    private boolean initialized = false;
    private JPanel jPanel1;
    private JLabel label;
    private JTextField nameField;
    private JCheckBox renameGettersAndCheckersCheckBox;
    private JCheckBox renameTestClassCheckBox;
    private JCheckBox renameTestClassMethodCheckBox;
    private JCheckBox textCheckBox;
    private JCheckBox updateReferencesCheckBox;

    public RenamePanel(TreePathHandle handle, String oldName, ChangeListener parent, String name, boolean editable, boolean showUpdateReferences) {
        this.setName(name);
        this.oldName = oldName;
        this.parent = parent;
        this.handle = handle;
        this.initComponents();
        this.updateReferencesCheckBox.setVisible(showUpdateReferences);
        this.nameField.setEnabled(editable);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }
        });
        this.renameGettersAndCheckersCheckBox.setVisible(false);
        this.renameTestClassCheckBox.setVisible(false);
        this.renameTestClassMethodCheckBox.setVisible(false);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.handle != null && this.handle.getKind() != Tree.Kind.LABELED_STATEMENT && this.handle.getElementHandle() != null && (this.handle.getElementHandle().getKind() == ElementKind.FIELD || this.handle.getElementHandle().getKind() == ElementKind.CLASS || this.handle.getElementHandle().getKind() == ElementKind.METHOD)) {
            JavaSource source = JavaSource.forFileObject((FileObject)this.handle.getFileObject());
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    if (RenamePanel.this.handle.getElementHandle().getKind() == ElementKind.FIELD) {
                        VariableElement element = (VariableElement)RenamePanel.this.handle.resolveElement((CompilationInfo)info);
                        if (element == null) {
                            LOG.log(Level.WARNING, "Cannot resolve ElementHandle {0} {1}", new Object[]{RenamePanel.this.handle, info.getClasspathInfo()});
                            return;
                        }
                        TypeElement parent = (TypeElement)element.getEnclosingElement();
                        boolean hasGetters = false;
                        for (ExecutableElement method : ElementFilter.methodsIn(parent.getEnclosedElements())) {
                            if (!RefactoringUtils.isGetter((CompilationInfo)info, method, element) && !RefactoringUtils.isSetter((CompilationInfo)info, method, element)) continue;
                            hasGetters = true;
                            break;
                        }
                        if (hasGetters) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RenamePanel.this.renameGettersAndCheckersCheckBox.setVisible(true);
                                }
                            });
                        }
                    }
                    if (RenamePanel.this.handle.getElementHandle().getKind() == ElementKind.CLASS || RenamePanel.this.handle.getElementHandle().getKind() == ElementKind.METHOD) {
                        final Element methodElement = RenamePanel.this.handle.resolveElement((CompilationInfo)info);
                        if (methodElement == null) {
                            LOG.log(Level.WARNING, "Cannot resolve ElementHandle {0} {1}", new Object[]{RenamePanel.this.handle, info.getClasspathInfo()});
                            return;
                        }
                        FileObject fileObject = RenamePanel.this.handle.getFileObject();
                        Collection testLocators = Lookup.getDefault().lookupAll(TestLocator.class);
                        for (final TestLocator testLocator : testLocators) {
                            if (!testLocator.appliesTo(fileObject)) continue;
                            if (testLocator.asynchronous()) {
                                testLocator.findOpposite(fileObject, -1, new TestLocator.LocationListener(){

                                    public void foundLocation(FileObject fo, TestLocator.LocationResult location) {
                                        if (RenamePanel.this.handle.getElementHandle().getKind() == ElementKind.CLASS) {
                                            RenamePanel.this.addTestFile(location, testLocator);
                                        } else if (RenamePanel.this.handle.getElementHandle().getKind() == ElementKind.METHOD) {
                                            RenamePanel.this.addTestMethod(location, testLocator, methodElement);
                                        }
                                    }
                                });
                                continue;
                            }
                            if (RenamePanel.this.handle.getElementHandle().getKind() == ElementKind.CLASS) {
                                RenamePanel.this.addTestFile(testLocator.findOpposite(fileObject, -1), testLocator);
                                continue;
                            }
                            if (RenamePanel.this.handle.getElementHandle().getKind() != ElementKind.METHOD) continue;
                            RenamePanel.this.addTestMethod(testLocator.findOpposite(fileObject, -1), testLocator, methodElement);
                        }
                    }
                }
            };
            try {
                source.runUserActionTask((Task)task, true);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        this.initialized = true;
    }

    private void addTestMethod(TestLocator.LocationResult location, TestLocator locator, final Element methodElement) {
        if (!this.renameTestClassMethodCheckBox.isVisible() && location != null && location.getFileObject() != null && locator.getFileType(location.getFileObject()) == TestLocator.FileType.TEST) {
            JavaSource js = JavaSource.forFileObject((FileObject)location.getFileObject());
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws IOException {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TestClassMethodsVisitor testClassVisitor = new TestClassMethodsVisitor((CompilationInfo)parameter);
                        testClassVisitor.scan(parameter.getCompilationUnit(), null);
                        if (testClassVisitor.containsTestMethod(methodElement)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RenamePanel.this.renameTestClassMethodCheckBox.setVisible(true);
                                }
                            });
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                Logger.getLogger(RenamePanel.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private void addTestFile(TestLocator.LocationResult location, TestLocator locator) {
        if (!this.renameTestClassCheckBox.isVisible() && location != null && location.getFileObject() != null && locator.getFileType(location.getFileObject()) == TestLocator.FileType.TEST) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RenamePanel.this.renameTestClassCheckBox.setVisible(true);
                }
            });
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.nameField.isEnabled()) {
            this.nameField.requestFocusInWindow();
        } else {
            this.textCheckBox.requestFocusInWindow();
        }
        return true;
    }

    private void initComponents() {
        this.label = new JLabel();
        this.nameField = new JTextField();
        this.jPanel1 = new JPanel();
        this.textCheckBox = new JCheckBox();
        this.updateReferencesCheckBox = new JCheckBox();
        this.renameGettersAndCheckersCheckBox = new JCheckBox();
        this.renameTestClassCheckBox = new JCheckBox();
        this.renameTestClassMethodCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        this.label.setHorizontalAlignment(2);
        this.label.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(RenamePanel.class, (String)"LBL_NewName"));
        this.add((Component)this.label, new GridBagConstraints());
        this.nameField.setText(this.oldName);
        this.nameField.selectAll();
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                RenamePanel.this.nameFieldFocusLost(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        this.nameField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_nameField"));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.textCheckBox.setSelected(RefactoringModule.getOption("searchInComments.rename", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.textCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameComments"));
        this.textCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RenamePanel.this.textCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.textCheckBox, gridBagConstraints);
        this.textCheckBox.getAccessibleContext().setAccessibleDescription(this.textCheckBox.getText());
        Mnemonics.setLocalizedText((AbstractButton)this.updateReferencesCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameWithoutRefactoring"));
        this.updateReferencesCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.updateReferencesCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.updateReferencesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.updateReferencesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.updateReferencesCheckBox, gridBagConstraints);
        this.renameGettersAndCheckersCheckBox.setSelected(RefactoringModule.getOption("gettersAndSetters.rename", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.renameGettersAndCheckersCheckBox, (String)NbBundle.getMessage(RenamePanel.class, (String)"RenamePanel.renameGettersAndCheckersCheckBox.text"));
        this.renameGettersAndCheckersCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RenamePanel.this.renameGettersAndCheckersCheckBoxItemStateChanged(evt);
            }
        });
        this.renameGettersAndCheckersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.renameGettersAndCheckersCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.renameGettersAndCheckersCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.renameTestClassCheckBox, (String)NbBundle.getMessage(RenamePanel.class, (String)"RenamePanel.renameTestClassCheckBox.text"));
        this.renameTestClassCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RenamePanel.this.renameTestClassCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.renameTestClassCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.renameTestClassMethodCheckBox, (String)NbBundle.getMessage(RenamePanel.class, (String)"RenamePanel.renameTestClassMethodCheckBox.text"));
        this.renameTestClassMethodCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RenamePanel.this.renameTestClassMethodCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.renameTestClassMethodCheckBox, gridBagConstraints);
    }

    private void updateReferencesCheckBoxActionPerformed(ActionEvent evt) {
        this.textCheckBox.setEnabled(!this.updateReferencesCheckBox.isSelected());
        this.parent.stateChanged(null);
    }

    private void textCheckBoxItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.rename", b);
    }

    private void renameGettersAndCheckersCheckBoxActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void renameTestClassCheckBoxStateChanged(ChangeEvent evt) {
        this.parent.stateChanged(null);
    }

    private void renameTestClassMethodCheckBoxStateChanged(ChangeEvent evt) {
        this.parent.stateChanged(null);
    }

    private void renameGettersAndCheckersCheckBoxItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("gettersAndSetters.rename", b);
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        this.parent.stateChanged(null);
    }

    public String getNameValue() {
        return this.nameField.getText();
    }

    public boolean searchJavadoc() {
        return this.textCheckBox.isSelected();
    }

    public boolean isUpdateReferences() {
        return !this.updateReferencesCheckBox.isVisible() || !this.updateReferencesCheckBox.isSelected();
    }

    public boolean isRenameGettersSetters() {
        return this.renameGettersAndCheckersCheckBox.isSelected();
    }

    public Component getComponent() {
        return this;
    }

    boolean isRenameTestClass() {
        return this.renameTestClassCheckBox.isSelected();
    }

    boolean isRenameTestClassMethod() {
        return this.renameTestClassMethodCheckBox.isSelected();
    }

    private class TestClassMethodsVisitor
    extends ErrorAwareTreePathScanner<Void, Void> {
        private CompilationInfo info;
        private List<ExecutableElement> testClassMethods;

        public TestClassMethodsVisitor(CompilationInfo info) {
            this.info = info;
        }

        public Void visitClass(ClassTree t, Void v) {
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null) {
                this.testClassMethods = ElementFilter.methodsIn(((TypeElement)el).getEnclosedElements());
            }
            return null;
        }

        public boolean containsTestMethod(Element methodElement) {
            if (this.testClassMethods != null) {
                String methodName = RefactoringUtils.getTestMethodName(methodElement.getSimpleName().toString());
                for (ExecutableElement testClassMethod : this.testClassMethods) {
                    if (!testClassMethod.getSimpleName().contentEquals(methodName) || testClassMethod.getReturnType().getKind() != TypeKind.VOID) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

