/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.text.AttributeSet;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.DocumentViewOp;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.SplitOffsetHighlightsSequence;

public final class PrependedTextView
extends EditorView {
    private final AttributeSet attributes;
    private final EditorView delegate;
    private final TextLayout prependedTextLayout;
    private final double prependedTextWidth;

    public PrependedTextView(DocumentViewOp op, AttributeSet attributes, EditorView delegate) {
        super(null);
        this.attributes = attributes;
        this.delegate = delegate;
        Font font = ViewUtils.getFont(attributes, op.getDefaultHintFont());
        this.prependedTextLayout = op.createTextLayout((String)attributes.getAttribute("virtual-text-prepend"), font);
        float width = this.prependedTextLayout.getAdvance();
        double em = op.getDefaultCharWidth();
        this.prependedTextWidth = Math.ceil((double)width / em) * em;
    }

    @Override
    public float getPreferredSpan(int axis) {
        float superSpan = this.delegate.getPreferredSpan(axis);
        if (axis == 0) {
            superSpan = (float)((double)superSpan + this.prependedTextWidth);
        }
        return superSpan;
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attributes;
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        Shape res = this.delegate.modelToViewChecked(offset, alloc, bias);
        Rectangle2D rect = ViewUtils.shapeAsRect(res);
        rect.setRect(rect.getX() + this.prependedTextWidth, rect.getY(), rect.getWidth(), rect.getHeight());
        return rect;
    }

    @Override
    public void paint(Graphics2D g, Shape hViewAlloc, Rectangle clipBounds) {
        Rectangle2D span = ViewUtils.shapeAsRect(hViewAlloc);
        span.setRect(span.getX() + this.prependedTextWidth, span.getY(), span.getWidth() - this.prependedTextWidth, span.getHeight());
        this.delegate.paint(g, span, clipBounds);
        span.setRect(span.getX() - this.prependedTextWidth, span.getY(), this.prependedTextWidth, span.getHeight());
        SplitOffsetHighlightsSequence highlights = this.getDocumentView().getPaintHighlights(this, 0);
        if (highlights.moveNext()) {
            AttributeSet attrs = highlights.getAttributes();
            HighlightsViewUtils.fillBackground(g, span, attrs, this.getDocumentView().getTextComponent());
            HighlightsViewUtils.paintBackgroundHighlights(g, span, attrs, this.getDocumentView());
        }
        g.setColor(Color.gray);
        span.setRect(span.getX(), span.getY(), this.prependedTextWidth, span.getHeight());
        HighlightsViewUtils.paintTextLayout(g, span, this.prependedTextLayout, this.getDocumentView());
    }

    ParagraphView getParagraphView() {
        return (ParagraphView)this.getParent();
    }

    DocumentView getDocumentView() {
        ParagraphView paragraphView = this.getParagraphView();
        return paragraphView != null ? paragraphView.getDocumentView() : null;
    }

    @Override
    public int getRawEndOffset() {
        return this.delegate.getRawEndOffset();
    }

    @Override
    public void setRawEndOffset(int offset) {
        this.delegate.setRawEndOffset(offset);
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        Rectangle2D bounds = ViewUtils.shapeAsRect(alloc);
        bounds.setRect(bounds.getX() + this.prependedTextWidth, bounds.getY(), bounds.getWidth() - this.prependedTextWidth, bounds.getHeight());
        if (x <= bounds.getX()) {
            return this.getStartOffset();
        }
        return this.delegate.viewToModelChecked(x, y, bounds, biasReturn);
    }

    @Override
    public int getLength() {
        return this.delegate.getLength();
    }

    @Override
    public int getStartOffset() {
        return this.delegate.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.delegate.getEndOffset();
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        this.delegate.setParent(parent);
    }

    EditorView getDelegate() {
        return this.delegate;
    }
}

