/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher.queries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class MultiSourceRootProvider
implements ClassPathProvider {
    private static final RequestProcessor WORKER = new RequestProcessor(MultiSourceRootProvider.class.getName(), 1, false, false);
    private static final Logger LOG = Logger.getLogger(MultiSourceRootProvider.class.getName());
    public static boolean DISABLE_MULTI_SOURCE_ROOT = Boolean.getBoolean("java.disable.multi.source.root");
    public static boolean SYNCHRONOUS_UPDATES = false;
    private static final Set<String> MODULAR_DIRECTORY_OPTIONS = Set.of("--module-path", "-p");
    private static final Set<String> CLASSPATH_OPTIONS = Set.of("--class-path", "-cp", "-classpath");
    private Map<FileObject, ClassPath> file2SourceCP = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, ClassPath> root2SourceCP = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, Runnable> root2RegistrationRefresh = new WeakHashMap<FileObject, Runnable>();
    private final Set<FileObject> registeredRoots = Collections.newSetFromMap(new WeakHashMap());
    private Map<FileObject, ClassPath> file2AllPath = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, ClassPath> file2ClassPath = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, ClassPath> file2ModulePath = new WeakHashMap<FileObject, ClassPath>();
    private static final Set<JavaTokenId> IGNORED_TOKENS = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
    private static final Set<JavaTokenId> STOP_TOKENS = EnumSet.of(JavaTokenId.IMPORT, new JavaTokenId[]{JavaTokenId.PUBLIC, JavaTokenId.PROTECTED, JavaTokenId.PRIVATE, JavaTokenId.CLASS, JavaTokenId.LBRACE});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSupportedFile(FileObject file) {
        ArrayList<FileObject> registeredRootsCopy;
        if (!Objects.equals("file", file.toURI().getScheme())) {
            return false;
        }
        if (SingleSourceFileUtil.isSingleSourceFile(file)) {
            return true;
        }
        Set<FileObject> set = this.registeredRoots;
        synchronized (set) {
            registeredRootsCopy = new ArrayList<FileObject>(this.registeredRoots);
        }
        for (FileObject existingRoot : registeredRootsCopy) {
            if (!file.equals(existingRoot) && !FileUtil.isParentOf((FileObject)existingRoot, (FileObject)file)) continue;
            return true;
        }
        return false;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (SYNCHRONOUS_UPDATES) {
            WORKER.post(() -> {}).waitFinished();
        }
        if (!this.isSupportedFile(file)) {
            return null;
        }
        switch (type) {
            case "classpath/source": {
                return this.getSourcePath(file);
            }
            case "classpath/compile": {
                return this.attributeBasedPath(file, this.file2AllPath, "-classpath", "-cp", "--class-path", "--module-path", "-p");
            }
            case "modules/classpath": {
                return this.attributeBasedPath(file, this.file2ClassPath, "-classpath", "-cp", "--class-path");
            }
            case "modules/compile": {
                return this.attributeBasedPath(file, this.file2ModulePath, "--module-path", "-p");
            }
            case "classpath/boot": 
            case "modules/boot": {
                return this.getBootPath(file);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getSourcePath(FileObject file) {
        if (!SingleSourceFileUtil.isSupportedFile(file)) {
            return null;
        }
        MultiSourceRootProvider multiSourceRootProvider = this;
        synchronized (multiSourceRootProvider) {
            if (file.isValid() && file.isData() && "text/x-java".equals(file.getMIMEType())) {
                return this.file2SourceCP.computeIfAbsent(file, f -> {
                    try {
                        String content = new String(file.asBytes(), FileEncodingQuery.getEncoding((FileObject)file));
                        String packName = MultiSourceRootProvider.findPackage(content);
                        FileObject root = file.getParent();
                        if (packName != null) {
                            List<String> packageParts = Arrays.asList(packName.split("\\."));
                            Collections.reverse(packageParts);
                            for (String packagePart : packageParts) {
                                if (!root.getNameExt().equalsIgnoreCase(packagePart)) {
                                    return null;
                                }
                                root = root.getParent();
                            }
                        }
                        ClassPath srcCP = this.root2SourceCP.computeIfAbsent(root, r -> ClassPathSupport.createClassPath(Arrays.asList(new RootPathResourceImplementation((FileObject)r))));
                        SingleSourceFileUtil.ParsedFileOptions options = SingleSourceFileUtil.getOptionsFor(root);
                        if (options != null) {
                            WORKER.post(this.root2RegistrationRefresh.computeIfAbsent(root, r -> new RegistrationRefresh(srcCP, options, (FileObject)r)));
                        }
                        return srcCP;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Failed to read sourcefile " + file, ex);
                        return null;
                    }
                });
            }
            FileObject folder = file;
            while (!folder.isRoot()) {
                ClassPath cp = this.root2SourceCP.get(folder);
                if (cp != null) {
                    return cp;
                }
                folder = folder.getParent();
            }
            return null;
        }
    }

    private synchronized FileObject getSourceRootImpl(FileObject file) {
        for (FileObject root : this.root2SourceCP.keySet()) {
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return root;
        }
        return null;
    }

    public FileObject getSourceRoot(FileObject file) {
        FileObject root = this.getSourceRootImpl(file);
        if (root == null) {
            this.getSourcePath(file);
            root = this.getSourceRootImpl(file);
        }
        return root;
    }

    public boolean isSourceLauncher(FileObject file) {
        return this.getSourceRoot(file) != null;
    }

    private ClassPath getBootPath(FileObject file) {
        if (this.isSourceLauncher(file)) {
            return JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        return null;
    }

    static String findPackage(String fileContext) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)fileContext, (boolean)true, (Language)JavaTokenId.language(), IGNORED_TOKENS, null);
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        ts.moveStart();
        while (ts.moveNext()) {
            if (ts.token().id() == JavaTokenId.PACKAGE) {
                StringBuilder packageName = new StringBuilder();
                while (ts.moveNext() && (ts.token().id() == JavaTokenId.DOT || ts.token().id() == JavaTokenId.IDENTIFIER)) {
                    packageName.append(ts.token().text());
                }
                return packageName.toString();
            }
            if (!STOP_TOKENS.contains(ts.token().id())) continue;
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath attributeBasedPath(FileObject file, Map<FileObject, ClassPath> file2ClassPath, String ... optionKeys) {
        if (!this.isSourceLauncher(file)) {
            return null;
        }
        MultiSourceRootProvider multiSourceRootProvider = this;
        synchronized (multiSourceRootProvider) {
            return file2ClassPath.computeIfAbsent(file, f -> {
                SingleSourceFileUtil.ParsedFileOptions delegate = SingleSourceFileUtil.getOptionsFor(f);
                if (delegate == null) {
                    return null;
                }
                AttributeBasedClassPathImplementation cpi = new AttributeBasedClassPathImplementation(delegate, optionKeys);
                return ClassPathFactory.createClassPath((ClassPathImplementation)cpi);
            });
        }
    }

    private static final class AttributeBasedClassPathImplementation
    extends FileChangeAdapter
    implements ChangeListener,
    ClassPathImplementation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final RequestProcessor.Task updateDelegatesTask = WORKER.create(this::doUpdateDelegates);
        private final Set<String> directoriesWithListener = new HashSet<String>();
        private final SingleSourceFileUtil.ParsedFileOptions delegate;
        private final Set<String> optionKeys;
        private Set<URL> currentURLs;
        private List<? extends PathResourceImplementation> delegates = Collections.emptyList();

        public AttributeBasedClassPathImplementation(SingleSourceFileUtil.ParsedFileOptions delegate, String ... optionKeys) {
            this.delegate = delegate;
            this.optionKeys = new HashSet<String>(Arrays.asList(optionKeys));
            delegate.addChangeListener(this);
            this.updateDelegates();
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.updateDelegates();
        }

        private void updateDelegates() {
            if (SYNCHRONOUS_UPDATES) {
                this.doUpdateDelegates();
            } else {
                this.updateDelegatesTask.schedule(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUpdateDelegates() {
            HashSet<URL> newURLs = new HashSet<URL>();
            ArrayList<? extends PathResourceImplementation> newDelegates = new ArrayList<PathResourceImplementation>();
            List<? extends String> parsed = this.delegate.getArguments();
            File workDirectory = Utilities.toFile((URI)this.delegate.getWorkDirectory());
            HashSet<String> toRemoveFSListeners = new HashSet<String>();
            HashSet<String> addedFSListeners = new HashSet<String>();
            AttributeBasedClassPathImplementation attributeBasedClassPathImplementation = this;
            synchronized (attributeBasedClassPathImplementation) {
                toRemoveFSListeners.addAll(this.directoriesWithListener);
            }
            for (int i = 0; i < parsed.size() - 1; ++i) {
                String currentOption = parsed.get(i);
                if (!this.optionKeys.contains(currentOption)) continue;
                for (String piece : parsed.get(i + 1).split(File.pathSeparator)) {
                    List<File> expandedPaths;
                    File pieceFile;
                    char sep;
                    boolean hasStar = false;
                    boolean isClassPath = CLASSPATH_OPTIONS.contains(currentOption);
                    if (isClassPath && piece.endsWith("*") && piece.length() > 1 && ((sep = piece.charAt(piece.length() - 2)) == File.separatorChar || sep == '/')) {
                        hasStar = true;
                        piece = piece.substring(0, piece.length() - 2);
                    }
                    if (!(pieceFile = new File(piece)).isAbsolute()) {
                        pieceFile = new File(workDirectory, piece);
                    }
                    File f = FileUtil.normalizeFile((File)pieceFile);
                    if (MODULAR_DIRECTORY_OPTIONS.contains(currentOption) && !toRemoveFSListeners.remove(f.getAbsolutePath()) && addedFSListeners.add(f.getAbsolutePath())) {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                    }
                    if (MODULAR_DIRECTORY_OPTIONS.contains(currentOption) && f.isDirectory() && !new File(f, "module-info.class").exists()) {
                        children = f.listFiles();
                        expandedPaths = children != null ? Arrays.asList(children) : Collections.emptyList();
                    } else if (hasStar && isClassPath) {
                        if (!toRemoveFSListeners.remove(f.getAbsolutePath()) && addedFSListeners.add(f.getAbsolutePath())) {
                            FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                        }
                        expandedPaths = (children = f.listFiles()) != null ? Arrays.stream(children).filter(c -> c.getName().toLowerCase(Locale.ROOT).endsWith(".jar")).toList() : Collections.emptyList();
                    } else {
                        expandedPaths = Arrays.asList(f);
                    }
                    for (File expanded : expandedPaths) {
                        URL u = FileUtil.urlForArchiveOrDir((File)expanded);
                        if (u == null) {
                            LOG.log(Level.INFO, "While parsing command line option '{0}' with parameter '{1}', path entry looks to be invalid: '{2}'", new Object[]{currentOption, parsed.get(i + 1), piece});
                            continue;
                        }
                        newURLs.add(u);
                        newDelegates.add((PathResourceImplementation)ClassPathSupport.createResource((URL)u));
                    }
                }
            }
            for (String removeFSListener : toRemoveFSListeners) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)new File(removeFSListener));
            }
            AttributeBasedClassPathImplementation attributeBasedClassPathImplementation2 = this;
            synchronized (attributeBasedClassPathImplementation2) {
                if (Objects.equals(this.currentURLs, newURLs)) {
                    return;
                }
                this.currentURLs = newURLs;
                this.delegates = newDelegates;
                this.directoriesWithListener.removeAll(toRemoveFSListeners);
                this.directoriesWithListener.addAll(addedFSListeners);
            }
            this.pcs.firePropertyChange("resources", null, null);
        }

        public synchronized List<? extends PathResourceImplementation> getResources() {
            return this.delegates;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public void fileDataCreated(FileEvent fe) {
            this.updateDelegates();
        }

        public void fileDeleted(FileEvent fe) {
            this.updateDelegates();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.updateDelegates();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.updateDelegates();
        }
    }

    private class RegistrationRefresh
    implements ChangeListener,
    Runnable {
        private final ClassPath srcCP;
        private final SingleSourceFileUtil.ParsedFileOptions options;
        private final FileObject root;

        public RegistrationRefresh(ClassPath srcCP, SingleSourceFileUtil.ParsedFileOptions options, FileObject root) {
            this.srcCP = srcCP;
            this.options = options;
            this.root = root;
            options.addChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GlobalPathRegistry registry = GlobalPathRegistry.getDefault();
            if (this.options.registerRoot()) {
                Set<FileObject> set = MultiSourceRootProvider.this.registeredRoots;
                synchronized (set) {
                    MultiSourceRootProvider.this.registeredRoots.add(this.root);
                }
                registry.register("classpath/source", new ClassPath[]{this.srcCP});
            } else {
                Set<FileObject> set = MultiSourceRootProvider.this.registeredRoots;
                synchronized (set) {
                    MultiSourceRootProvider.this.registeredRoots.remove(this.root);
                }
                if (registry.getPaths("classpath/source").contains(this.srcCP)) {
                    registry.unregister("classpath/source", new ClassPath[]{this.srcCP});
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            WORKER.post((Runnable)this);
        }
    }

    private static final class RootPathResourceImplementation
    implements FilteringPathResourceImplementation {
        private final URL root;
        private final URL[] roots;
        private final AtomicReference<String> lastCheckedAsIncluded = new AtomicReference();

        public RootPathResourceImplementation(FileObject root) {
            this.root = root.toURL();
            this.roots = new URL[]{this.root};
        }

        public boolean includes(URL root, String resource) {
            boolean included;
            int lastSlash;
            if (!resource.endsWith("/") && (lastSlash = resource.lastIndexOf(47)) != -1) {
                resource = resource.substring(0, lastSlash + 1);
            }
            if (resource.equals(this.lastCheckedAsIncluded.get())) {
                return true;
            }
            FileObject fo = URLMapper.findFileObject((URL)root);
            fo = fo != null ? fo.getFileObject(resource) : null;
            boolean bl = included = fo == null || FileOwnerQuery.getOwner((FileObject)fo) == null;
            if (included) {
                this.lastCheckedAsIncluded.set(resource);
            }
            return included;
        }

        public URL[] getRoots() {
            return this.roots;
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }
}

