/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.autoupdate.services.MessageValidator;

public class MessageMultiValidator {
    private final List<MessageValidator> validators;

    public MessageMultiValidator(List<MessageValidator> validators) {
        this.validators = validators;
    }

    public MessageMultiValidator(MessageValidator ... validators) {
        this.validators = Arrays.asList(validators);
    }

    public void update(byte[] input, int offset, int len) {
        this.validators.stream().forEach(v -> v.update(input, offset, len));
    }

    public void update(byte[] input) {
        this.validators.stream().forEach(v -> v.update(input));
    }

    public void update(byte input) {
        this.validators.stream().forEach(v -> v.update(input));
    }

    public void reset() {
        this.validators.stream().forEach(v -> v.reset());
    }

    public boolean isValid() {
        return this.validators.stream().map(a -> a.isValid()).reduce(Boolean::logicalAnd).orElse(true);
    }

    public Collection<MessageValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }
}

