## API Report File for "@microsoft/fast-element"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export const $global: Global;

// @public
export interface Accessor {
    getValue(source: any): any;
    name: string;
    setValue(source: any, value: any): void;
}

// @public
export class AttachedBehaviorHTMLDirective<T = any> extends HTMLDirective {
    constructor(name: string, behavior: AttachedBehaviorType<T>, options: T);
    createBehavior(target: Node): Behavior;
    createPlaceholder(index: number): string;
}

// @public
export type AttachedBehaviorType<T = any> = new (target: any, options: T) => Behavior;

// @public
export function attr(config?: DecoratorAttributeConfiguration): (target: {}, property: string) => void;

// @public
export function attr(target: {}, prop: string): void;

// @public
export type AttributeConfiguration = {
    property: string;
    attribute?: string;
    mode?: AttributeMode;
    converter?: ValueConverter;
};

// @public
export const AttributeConfiguration: Readonly<{
    locate: (target: {}) => AttributeConfiguration[];
}>;

// @public
export class AttributeDefinition implements Accessor {
    constructor(Owner: Function, name: string, attribute?: string, mode?: AttributeMode, converter?: ValueConverter);
    readonly attribute: string;
    // @internal
    static collect(Owner: Function, ...attributeLists: (ReadonlyArray<string | AttributeConfiguration> | undefined)[]): ReadonlyArray<AttributeDefinition>;
    readonly converter?: ValueConverter;
    getValue(source: HTMLElement): any;
    readonly mode: AttributeMode;
    readonly name: string;
    // @internal (undocumented)
    onAttributeChangedCallback(element: HTMLElement, value: any): void;
    readonly Owner: Function;
    setValue(source: HTMLElement, newValue: any): void;
}

// @public
export type AttributeMode = "reflect" | "boolean" | "fromView";

// @public
export interface Behavior {
    bind(source: unknown, context: ExecutionContext): void;
    unbind(source: unknown): void;
}

// @public
export type Binding<TSource = any, TReturn = any, TParent = any> = (source: TSource, context: ExecutionContext<TParent>) => TReturn;

// @public
export class BindingBehavior implements Behavior {
    constructor(target: any, binding: Binding, isBindingVolatile: boolean, bind: typeof normalBind, unbind: typeof normalUnbind, updateTarget: typeof updatePropertyTarget, targetName?: string);
    // Warning: (ae-forgotten-export) The symbol "normalBind" needs to be exported by the entry point index.d.ts
    bind: typeof normalBind;
    // @internal (undocumented)
    binding: Binding;
    // @internal (undocumented)
    bindingObserver: BindingObserver | null;
    // @internal (undocumented)
    classVersions: Record<string, number>;
    // @internal (undocumented)
    context: ExecutionContext | null;
    // @internal (undocumented)
    handleChange(): void;
    // @internal (undocumented)
    handleEvent(event: Event): void;
    // @internal (undocumented)
    isBindingVolatile: boolean;
    // @internal (undocumented)
    source: unknown;
    // @internal (undocumented)
    target: any;
    // @internal (undocumented)
    targetName?: string;
    // Warning: (ae-forgotten-export) The symbol "normalUnbind" needs to be exported by the entry point index.d.ts
    unbind: typeof normalUnbind;
    // Warning: (ae-forgotten-export) The symbol "updatePropertyTarget" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    updateTarget: typeof updatePropertyTarget;
    // @internal (undocumented)
    version: number;
}

// @public
export interface BindingObserver<TSource = any, TReturn = any, TParent = any> extends Notifier {
    disconnect(): void;
    observe(source: TSource, context: ExecutionContext<TParent>): TReturn;
    records(): IterableIterator<ObservationRecord>;
}

// @public
export const booleanConverter: ValueConverter;

// @public
export type Callable = typeof Function.prototype.call | {
    call(): void;
};

// @public
export interface CaptureType<TSource> {
}

// @public
export interface ChildListBehaviorOptions<T = any> extends NodeBehaviorOptions<T>, Omit<MutationObserverInit, "subtree" | "childList"> {
}

// @public
export function children<T = any>(propertyOrOptions: (keyof T & string) | ChildrenBehaviorOptions<keyof T & string>): CaptureType<T>;

// Warning: (ae-forgotten-export) The symbol "NodeObservationBehavior" needs to be exported by the entry point index.d.ts
//
// @public
export class ChildrenBehavior extends NodeObservationBehavior<ChildrenBehaviorOptions> {
    constructor(target: HTMLElement, options: ChildrenBehaviorOptions);
    disconnect(): void;
    protected getNodes(): ChildNode[];
    observe(): void;
}

// @public
export type ChildrenBehaviorOptions<T = any> = ChildListBehaviorOptions<T> | SubtreeBehaviorOptions<T>;

// @beta
export interface CompilationResult {
    fragment: DocumentFragment;
    hostBehaviorFactories: NodeBehaviorFactory[];
    targetOffset: number;
    viewBehaviorFactories: NodeBehaviorFactory[];
}

// Warning: (ae-incompatible-release-tags) The symbol "compileTemplate" is marked as @public, but its signature references "CompilationResult" which is marked as @beta
//
// @public
export function compileTemplate(template: HTMLTemplateElement, directives: ReadonlyArray<HTMLDirective>): CompilationResult;

// @public
export type ComposableStyles = string | ElementStyles | CSSStyleSheet;

// @public
export type Constructable<T = {}> = {
    new (...args: any[]): T;
};

// @public
export class Controller extends PropertyChangeNotifier {
    // @internal
    constructor(element: HTMLElement, definition: FASTElementDefinition);
    addBehaviors(behaviors: ReadonlyArray<Behavior>): void;
    addStyles(styles: ElementStyles | HTMLStyleElement): void;
    readonly definition: FASTElementDefinition;
    readonly element: HTMLElement;
    emit(type: string, detail?: any, options?: Omit<CustomEventInit, "detail">): void | boolean;
    static forCustomElement(element: HTMLElement): Controller;
    get isConnected(): boolean;
    onAttributeChangedCallback(name: string, oldValue: string, newValue: string): void;
    onConnectedCallback(): void;
    onDisconnectedCallback(): void;
    removeBehaviors(behaviors: ReadonlyArray<Behavior>, force?: boolean): void;
    removeStyles(styles: ElementStyles | HTMLStyleElement): void;
    get styles(): ElementStyles | null;
    set styles(value: ElementStyles | null);
    get template(): ElementViewTemplate | null;
    set template(value: ElementViewTemplate | null);
    readonly view: ElementView | null;
}

// Warning: (ae-internal-missing-underscore) The name "createMetadataLocator" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function createMetadataLocator<TMetadata>(): (target: {}) => TMetadata[];

// @public
export function css(strings: TemplateStringsArray, ...values: (ComposableStyles | CSSDirective)[]): ElementStyles;

// @public
export class CSSDirective {
    createBehavior(): Behavior | undefined;
    createCSS(): ComposableStyles;
}

// @public
export function cssPartial(strings: TemplateStringsArray, ...values: (ComposableStyles | CSSDirective)[]): CSSDirective;

// @public
export function customElement(nameOrDef: string | PartialFASTElementDefinition): (type: Function) => void;

// @public
export type DecoratorAttributeConfiguration = Omit<AttributeConfiguration, "property">;

// @public
export const defaultExecutionContext: ExecutionContext<any, any>;

// @public
export const DOM: Readonly<{
    supportsAdoptedStyleSheets: boolean;
    setHTMLPolicy(policy: TrustedTypesPolicy): void;
    createHTML(html: string): string;
    isMarker(node: Node): node is Comment;
    extractDirectiveIndexFromMarker(node: Comment): number;
    createInterpolationPlaceholder(index: number): string;
    createCustomAttributePlaceholder(attributeName: string, index: number): string;
    createBlockPlaceholder(index: number): string;
    queueUpdate: (callable: Callable) => void;
    processUpdates: () => void;
    nextUpdate(): Promise<void>;
    setAttribute(element: HTMLElement, attributeName: string, value: any): void;
    setBooleanAttribute(element: HTMLElement, attributeName: string, value: boolean): void;
    removeChildNodes(parent: Node): void;
    createTemplateWalker(fragment: DocumentFragment): TreeWalker;
}>;

// @public
export function elements(selector?: string): ElementsFilter;

// @public
export type ElementsFilter = (value: Node, index: number, array: Node[]) => boolean;

// @public
export type ElementStyleFactory = (styles: ReadonlyArray<ComposableStyles>) => ElementStyles;

// @public
export abstract class ElementStyles {
    // @internal (undocumented)
    addStylesTo(target: StyleTarget): void;
    // @internal (undocumented)
    abstract readonly behaviors: ReadonlyArray<Behavior> | null;
    static readonly create: ElementStyleFactory;
    // @internal (undocumented)
    isAttachedTo(target: StyleTarget): boolean;
    // @internal (undocumented)
    removeStylesFrom(target: StyleTarget): void;
    // @internal (undocumented)
    abstract readonly styles: ReadonlyArray<ComposableStyles>;
    withBehaviors(...behaviors: Behavior[]): this;
}

// @public
export interface ElementView extends View {
    appendTo(node: Node): void;
}

// @public
export interface ElementViewTemplate {
    create(hostBindingTarget: Element): ElementView;
    render(source: any, host: Node, hostBindingTarget?: Element): HTMLView;
}

// Warning: (ae-internal-missing-underscore) The name "emptyArray" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export const emptyArray: readonly never[];

// @public
export function enableArrayObservation(): void;

// @public
export class ExecutionContext<TParent = any, TGrandparent = any> {
    get event(): Event;
    index: number;
    get isEven(): boolean;
    get isFirst(): boolean;
    get isInMiddle(): boolean;
    get isLast(): boolean;
    get isOdd(): boolean;
    length: number;
    parent: TParent;
    parentContext: ExecutionContext<TGrandparent>;
    // @internal
    static setEvent(event: Event | null): void;
}

// Warning: (ae-internal-missing-underscore) The name "FAST" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export const FAST: FASTGlobal;

// @public
export interface FASTElement {
    $emit(type: string, detail?: any, options?: Omit<CustomEventInit, "detail">): boolean | void;
    readonly $fastController: Controller;
    attributeChangedCallback(name: string, oldValue: string, newValue: string): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
}

// @public
export const FASTElement: (new () => HTMLElement & FASTElement) & {
    from<TBase extends {
        new (): HTMLElement;
        prototype: HTMLElement;
    }>(BaseType: TBase): new () => InstanceType<TBase> & FASTElement;
    define<TType extends Function>(type: TType, nameOrDef?: string | PartialFASTElementDefinition | undefined): TType;
};

// @public
export class FASTElementDefinition<TType extends Function = Function> {
    constructor(type: TType, nameOrConfig?: PartialFASTElementDefinition | string);
    readonly attributeLookup: Record<string, AttributeDefinition>;
    readonly attributes: ReadonlyArray<AttributeDefinition>;
    define(registry?: CustomElementRegistry): this;
    readonly elementOptions?: ElementDefinitionOptions;
    static readonly forType: <TType_1 extends Function>(key: TType_1) => FASTElementDefinition<Function> | undefined;
    get isDefined(): boolean;
    readonly name: string;
    readonly propertyLookup: Record<string, AttributeDefinition>;
    readonly shadowOptions?: ShadowRootInit;
    readonly styles?: ElementStyles;
    readonly template?: ElementViewTemplate;
    readonly type: TType;
}

// Warning: (ae-internal-missing-underscore) The name "FASTGlobal" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export interface FASTGlobal {
    getById<T>(id: string | number): T | null;
    // (undocumented)
    getById<T>(id: string | number, initialize: () => T): T;
    readonly versions: string[];
}

// @public
export type Global = typeof globalThis & {
    trustedTypes: TrustedTypes;
    readonly FAST: FASTGlobal;
};

// @public
export function html<TSource = any, TParent = any>(strings: TemplateStringsArray, ...values: TemplateValue<TSource, TParent>[]): ViewTemplate<TSource, TParent>;

// @public
export class HTMLBindingDirective extends TargetedHTMLDirective {
    constructor(binding: Binding);
    // (undocumented)
    binding: Binding;
    createBehavior(target: Node): BindingBehavior;
    targetAtContent(): void;
    get targetName(): string | undefined;
    set targetName(value: string | undefined);
}

// @public
export abstract class HTMLDirective implements NodeBehaviorFactory {
    abstract createBehavior(target: Node): Behavior;
    abstract createPlaceholder(index: number): string;
    targetIndex: number;
}

// @public
export class HTMLView implements ElementView, SyntheticView {
    constructor(fragment: DocumentFragment, behaviors: Behavior[]);
    appendTo(node: Node): void;
    bind(source: unknown, context: ExecutionContext): void;
    context: ExecutionContext | null;
    dispose(): void;
    static disposeContiguousBatch(views: SyntheticView[]): void;
    firstChild: Node;
    insertBefore(node: Node): void;
    lastChild: Node;
    remove(): void;
    source: any | null;
    unbind(): void;
}

// Warning: (ae-internal-missing-underscore) The name "KernelServiceId" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export const enum KernelServiceId {
    // (undocumented)
    contextEvent = 3,
    // (undocumented)
    elementRegistry = 4,
    // (undocumented)
    observable = 2,
    // (undocumented)
    updateQueue = 1
}

// Warning: (ae-internal-missing-underscore) The name "Mutable" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export type Mutable<T> = {
    -readonly [P in keyof T]: T[P];
};

// @public
export interface NodeBehaviorFactory {
    createBehavior(target: Node): Behavior;
    targetIndex: number;
}

// @public
export interface NodeBehaviorOptions<T = any> {
    filter?: ElementsFilter;
    property: T;
}

// @public
export interface Notifier {
    notify(args: any): void;
    readonly source: any;
    subscribe(subscriber: Subscriber, propertyToWatch?: any): void;
    unsubscribe(subscriber: Subscriber, propertyToUnwatch?: any): void;
}

// @public
export const nullableNumberConverter: ValueConverter;

// @public
export const Observable: Readonly<{
    setArrayObserverFactory(factory: (collection: any[]) => Notifier): void;
    getNotifier: (source: any) => Notifier;
    track(source: unknown, propertyName: string): void;
    trackVolatile(): void;
    notify(source: unknown, args: any): void;
    defineProperty(target: {}, nameOrAccessor: string | Accessor): void;
    getAccessors: (target: {}) => Accessor[];
    binding<TSource = any, TReturn = any, TParent = any>(binding: Binding<TSource, TReturn, TParent>, initialSubscriber?: Subscriber | undefined, isVolatileBinding?: boolean): BindingObserver<TSource, TReturn, TParent>;
    isVolatileBinding<TSource_1 = any, TReturn_1 = any, TParent_1 = any>(binding: Binding<TSource_1, TReturn_1, TParent_1>): boolean;
}>;

// @public
export function observable(target: {}, nameOrAccessor: string | Accessor): void;

// @public
export interface ObservationRecord {
    propertyName: string;
    propertySource: any;
}

// @public
export interface PartialFASTElementDefinition {
    readonly attributes?: (AttributeConfiguration | string)[];
    readonly elementOptions?: ElementDefinitionOptions;
    readonly name: string;
    readonly shadowOptions?: Partial<ShadowRootInit> | null;
    readonly styles?: ComposableStyles | ComposableStyles[];
    readonly template?: ElementViewTemplate;
}

// @public
export class PropertyChangeNotifier implements Notifier {
    constructor(source: any);
    notify(propertyName: string): void;
    readonly source: any;
    subscribe(subscriber: Subscriber, propertyToWatch?: string): void;
    unsubscribe(subscriber: Subscriber, propertyToUnwatch?: string): void;
}

// @public
export function ref<T = any>(propertyName: keyof T & string): CaptureType<T>;

// @public
export class RefBehavior implements Behavior {
    constructor(target: HTMLElement, propertyName: string);
    bind(source: any): void;
    unbind(): void;
}

// @public
export function repeat<TSource = any, TItem = any>(itemsBinding: Binding<TSource, readonly TItem[]>, templateOrTemplateBinding: SyntheticViewTemplate | Binding<TSource, SyntheticViewTemplate>, options?: RepeatOptions): CaptureType<TSource>;

// @public
export class RepeatBehavior<TSource = any> implements Behavior, Subscriber {
    constructor(location: Node, itemsBinding: Binding<TSource, any[]>, isItemsBindingVolatile: boolean, templateBinding: Binding<TSource, SyntheticViewTemplate>, isTemplateBindingVolatile: boolean, options: RepeatOptions);
    bind(source: TSource, context: ExecutionContext): void;
    // @internal (undocumented)
    handleChange(source: any, args: Splice[]): void;
    unbind(): void;
}

// @public
export class RepeatDirective<TSource = any> extends HTMLDirective {
    constructor(itemsBinding: Binding, templateBinding: Binding<TSource, SyntheticViewTemplate>, options: RepeatOptions);
    createBehavior(target: Node): RepeatBehavior<TSource>;
    createPlaceholder: (index: number) => string;
    // (undocumented)
    readonly itemsBinding: Binding;
    // (undocumented)
    readonly options: RepeatOptions;
    // (undocumented)
    readonly templateBinding: Binding<TSource, SyntheticViewTemplate>;
}

// @public
export interface RepeatOptions {
    positioning?: boolean;
    recycle?: boolean;
}

// @public
export function slotted<T = any>(propertyOrOptions: (keyof T & string) | SlottedBehaviorOptions<keyof T & string>): CaptureType<T>;

// @public
export class SlottedBehavior extends NodeObservationBehavior<SlottedBehaviorOptions> {
    constructor(target: HTMLSlotElement, options: SlottedBehaviorOptions);
    disconnect(): void;
    protected getNodes(): Node[];
    observe(): void;
}

// @public
export interface SlottedBehaviorOptions<T = any> extends NodeBehaviorOptions<T>, AssignedNodesOptions {
}

// @public
export interface Splice {
    addedCount: number;
    index: number;
    removed: any[];
}

// @public
export interface StyleTarget {
    adoptedStyleSheets?: CSSStyleSheet[];
    append(styles: HTMLStyleElement): void;
    // @deprecated
    prepend(styles: HTMLStyleElement): void;
    querySelectorAll<E extends Element = Element>(selectors: string): NodeListOf<E>;
    removeChild(styles: HTMLStyleElement): void;
}

// @public
export interface Subscriber {
    handleChange(source: any, args: any): void;
}

// @public
export class SubscriberSet implements Notifier {
    constructor(source: any, initialSubscriber?: Subscriber);
    has(subscriber: Subscriber): boolean;
    notify(args: any): void;
    readonly source: any;
    subscribe(subscriber: Subscriber): void;
    unsubscribe(subscriber: Subscriber): void;
}

// @public
export interface SubtreeBehaviorOptions<T = any> extends Omit<NodeBehaviorOptions<T>, "filter">, Omit<MutationObserverInit, "subtree" | "childList"> {
    selector: string;
    subtree: boolean;
}

// @public
export interface SyntheticView extends View {
    dispose(): void;
    readonly firstChild: Node;
    insertBefore(node: Node): void;
    readonly lastChild: Node;
    remove(): void;
}

// @public
export interface SyntheticViewTemplate<TSource = any, TParent = any> {
    create(): SyntheticView;
}

// @public
export abstract class TargetedHTMLDirective extends HTMLDirective {
    createPlaceholder: (index: number) => string;
    abstract targetName: string | undefined;
}

// @public
export type TemplateValue<TScope, TParent = any> = Binding<TScope, any, TParent> | string | number | HTMLDirective | CaptureType<TScope>;

// @public
export type TrustedTypes = {
    createPolicy(name: string, rules: TrustedTypesPolicy): TrustedTypesPolicy;
};

// @public
export type TrustedTypesPolicy = {
    createHTML(html: string): string;
};

// @public
export interface ValueConverter {
    fromView(value: any): any;
    toView(value: any): any;
}

// @public
export interface View {
    bind(source: unknown, context: ExecutionContext): void;
    readonly context: ExecutionContext | null;
    dispose(): void;
    readonly source: any | null;
    unbind(): void;
}

// @public
export class ViewTemplate<TSource = any, TParent = any> implements ElementViewTemplate, SyntheticViewTemplate {
    constructor(html: string | HTMLTemplateElement, directives: ReadonlyArray<HTMLDirective>);
    create(hostBindingTarget?: Element): HTMLView;
    readonly directives: ReadonlyArray<HTMLDirective>;
    readonly html: string | HTMLTemplateElement;
    render(source: TSource, host: Node | string, hostBindingTarget?: Element): HTMLView;
}

// @public
export function volatile(target: {}, name: string | Accessor, descriptor: PropertyDescriptor): PropertyDescriptor;

// @public
export function when<TSource = any, TReturn = any>(binding: Binding<TSource, TReturn>, templateOrTemplateBinding: SyntheticViewTemplate | Binding<TSource, SyntheticViewTemplate>, elseTemplateOrTemplateBinding?: SyntheticViewTemplate | Binding<TSource, SyntheticViewTemplate>): CaptureType<TSource>;

// (No @packageDocumentation comment for this package)

```
