// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { css } from '@microsoft/fast-element';
import { disabledCursor, display, focusVisible, } from '@microsoft/fast-foundation';
import { borderWidth, checkboxBackground, checkboxBorder, designUnit, disabledOpacity, focusBorder, fontFamily, foreground, typeRampBaseFontSize, typeRampBaseLineHeight, } from '../design-tokens.js';
export const radioStyles = (context, definition) => css `
	${display('inline-flex')} :host {
		align-items: center;
		flex-direction: row;
		font-size: ${typeRampBaseFontSize};
		line-height: ${typeRampBaseLineHeight};
		margin: calc(${designUnit} * 1px) 0;
		outline: none;
		position: relative;
		transition: all 0.2s ease-in-out;
		user-select: none;
	}
	.control {
		background: ${checkboxBackground};
		border-radius: 999px;
		border: calc(${borderWidth} * 1px) solid ${checkboxBorder};
		box-sizing: border-box;
		cursor: pointer;
		height: calc(${designUnit} * 4px);
		position: relative;
		outline: none;
		width: calc(${designUnit} * 4px);
	}
	.label {
		color: ${foreground};
		cursor: pointer;
		font-family: ${fontFamily};
		margin-inline-end: calc(${designUnit} * 2px + 2px);
		padding-inline-start: calc(${designUnit} * 2px + 2px);
	}
	.label__hidden {
		display: none;
		visibility: hidden;
	}
	.control,
	.checked-indicator {
		flex-shrink: 0;
	}
	.checked-indicator {
		background: ${foreground};
		border-radius: 999px;
		display: inline-block;
		inset: calc(${designUnit} * 1px);
		opacity: 0;
		pointer-events: none;
		position: absolute;
	}
	:host(:not([disabled])) .control:hover {
		background: ${checkboxBackground};
		border-color: ${checkboxBorder};
	}
	:host(:not([disabled])) .control:active {
		background: ${checkboxBackground};
		border-color: ${focusBorder};
	}
	:host(:${focusVisible}) .control {
		border: calc(${borderWidth} * 1px) solid ${focusBorder};
	}
	:host([aria-checked='true']) .control {
		background: ${checkboxBackground};
		border: calc(${borderWidth} * 1px) solid ${checkboxBorder};
	}
	:host([aria-checked='true']:not([disabled])) .control:hover {
		background: ${checkboxBackground};
		border: calc(${borderWidth} * 1px) solid ${checkboxBorder};
	}
	:host([aria-checked='true']:not([disabled])) .control:active {
		background: ${checkboxBackground};
		border: calc(${borderWidth} * 1px) solid ${focusBorder};
	}
	:host([aria-checked="true"]:${focusVisible}:not([disabled])) .control {
		border: calc(${borderWidth} * 1px) solid ${focusBorder};
	}
	:host([disabled]) .label,
	:host([readonly]) .label,
	:host([readonly]) .control,
	:host([disabled]) .control {
		cursor: ${disabledCursor};
	}
	:host([aria-checked='true']) .checked-indicator {
		opacity: 1;
	}
	:host([disabled]) {
		opacity: ${disabledOpacity};
	}
`;
