"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.candidatesFromSpecificEnv = exports.candidatesFromPath = void 0;
const path = __importStar(require("path"));
const utils_1 = require("../utils");
function candidatesFromPath() {
    return __awaiter(this, void 0, void 0, function* () {
        const ret = [];
        if (process.env.PATH) {
            const jdkBinFolderFromPath = process.env.PATH.split(path.delimiter).filter(utils_1.looksLikeJavaHome)
                .map(utils_1.expandTilde); // '~' can occur in envs in Unix-like systems
            /**
             * Fix for https://github.com/Eskibear/node-jdk-utils/issues/2
             * Homebrew creates symbolic links for each binary instead of folder.
             */
            const homeDirs = yield Promise.all(jdkBinFolderFromPath.map(p => (0, utils_1.getRealHome)(path.dirname(p))));
            ret.push(...homeDirs);
        }
        return ret.filter(Boolean);
    });
}
exports.candidatesFromPath = candidatesFromPath;
function candidatesFromSpecificEnv(envkey) {
    return __awaiter(this, void 0, void 0, function* () {
        if (process.env[envkey]) {
            const rmSlash = process.env[envkey].replace(/[\\\/]$/, ""); // remove trailing slash if exists
            return (0, utils_1.getRealHome)(rmSlash);
        }
        return undefined;
    });
}
exports.candidatesFromSpecificEnv = candidatesFromSpecificEnv;
