"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.candidates = void 0;
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const logger_1 = require("../logger");
const utils_1 = require("../utils");
/*
 * Gradle Toolchains JDKs path format
 *
 * Windows
 * >cd %HOMEPATH%\.gradle\jdks
 * >wsl find ./ -type f -name java.exe
 * ./adoptopenjdk-15-amd64-windows/jdk-15.0.2+7/bin/java.exe
 * ./amazon_com_inc_-18-amd64-windows/jdk18.0.2_9/bin/java.exe
 * ./eclipse_adoptium-18-amd64-windows/jdk-18.0.2.1+1/bin/java.exe
 *
 * macOS
 * $ cd ~/.gradle/jdks
 * $ find ./ -type f -name java
 * ./adoptopenjdk-15-x64-mac_hotspot/jdk-15.0.2+7/Contents/Home/bin/java
 * ./amazon_com_inc_-18-x64-mac_hotspot/jdk18.0.2_9/Contents/Home/bin/java
 * ./eclipse_adoptium-18-x64-mac_hotspot/jdk-18.0.2.1+1/Contents/Home/bin/java
 *
 * Linux
 * $ cd ~/.gradle/jdks
 * $ find ./ -type f -name java
 * ./adoptopenjdk-15-amd64-linux/jdk-15.0.2+7/bin/java
 * ./amazon_com_inc_-18-amd64-linux/18.0.2.9.1/bin/java
 * ./eclipse_adoptium-18-amd64-linux/jdk-18.0.2.1+1/bin/java
 *
 * See https://docs.gradle.org/8.1/userguide/toolchains.html
 */
const GRADLE_USER_HOME = (_a = process.env.GRADLE_USER_HOME) !== null && _a !== void 0 ? _a : path.join(os.homedir(), ".gradle");
const JDK_BASE_DIR = path.join(GRADLE_USER_HOME, "jdks");
function candidates() {
    return __awaiter(this, void 0, void 0, function* () {
        const ret = [];
        try {
            for (const distro of yield fs.promises.readdir(JDK_BASE_DIR, { withFileTypes: true })) {
                if (distro.isDirectory()) {
                    const distroDir = path.join(JDK_BASE_DIR, distro.name);
                    const files = yield fs.promises.readdir(distroDir, { withFileTypes: true });
                    const homedirs = files.filter(file => file.isDirectory()).map(file => {
                        if (utils_1.isMac) {
                            return path.join(distroDir, file.name, "Contents", "Home");
                        }
                        else {
                            return path.join(distroDir, file.name);
                        }
                    });
                    ret.push(...homedirs);
                }
            }
        }
        catch (error) {
            (0, logger_1.log)(error);
        }
        return ret;
    });
}
exports.candidates = candidates;
