"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.candidates = exports.HOMEBREW_DIR_LINUX = exports.HOMEBREW_DIR_APPLE_SILLICON = exports.HOMEBREW_DIR_INTEL = void 0;
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const logger_1 = require("../logger");
const utils_1 = require("../utils");
/*
$ ls -l /usr/local/opt
openjdk -> ../Cellar/openjdk/15.0.1
openjdk@11 -> ../Cellar/openjdk@11/11.0.12
openjdk@15 -> ../Cellar/openjdk/15.0.1

$ ls -l /usr/local/opt/openjdk/bin/java
/usr/local/opt/openjdk/bin/java -> ../libexec/openjdk.jdk/Contents/Home/bin/java

# Real path is:
# /usr/local/Cellar/openjdk/15.0.1/libexec/openjdk.jdk/Contents/Home/bin/java

*/
/**
 * See: https://docs.brew.sh/Installation
 */
exports.HOMEBREW_DIR_INTEL = "/usr/local/opt";
exports.HOMEBREW_DIR_APPLE_SILLICON = "/opt/homebrew/opt";
exports.HOMEBREW_DIR_LINUX = "/home/linuxbrew/.linuxbrew/opt";
function candidates(homebrewOptPath) {
    return __awaiter(this, void 0, void 0, function* () {
        const ret = [];
        try {
            const files = yield fs.promises.readdir(homebrewOptPath, { withFileTypes: true });
            const homeDirLinks = files.filter(file => file.isSymbolicLink() && (0, utils_1.looksLikeJavaHome)(file.name)).map(file => path.join(homebrewOptPath, file.name));
            const actualHomeDirs = yield Promise.all((0, utils_1.deDup)(homeDirLinks).map(file => (0, utils_1.getRealHome)(file)));
            ret.push(...actualHomeDirs);
        }
        catch (error) {
            (0, logger_1.log)(error);
        }
        return ret.filter(Boolean);
    });
}
exports.candidates = candidates;
