"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.candidates = void 0;
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const logger_1 = require("../logger");
const utils_1 = require("../utils");
const JENV_DIR = path.join(os.homedir(), ".jenv");
const JDK_LINK_BASE_DIR = path.join(JENV_DIR, "versions");
function candidates() {
    return __awaiter(this, void 0, void 0, function* () {
        const ret = [];
        try {
            const files = yield fs.promises.readdir(JDK_LINK_BASE_DIR, { withFileTypes: true });
            const homeDirLinks = files.filter(file => file.isSymbolicLink()).map(file => path.join(JDK_LINK_BASE_DIR, file.name));
            const actualHomeDirs = yield Promise.all(homeDirLinks.map(file => fs.promises.realpath(file)));
            const uniqHomes = (0, utils_1.deDup)(actualHomeDirs);
            ret.push(...uniqHomes);
        }
        catch (error) {
            (0, logger_1.log)(error);
        }
        return ret;
    });
}
exports.candidates = candidates;
