"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.candidates = void 0;
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const logger_1 = require("../logger");
const utils_1 = require("../utils");
const PROGRAM_DIRS = Array.from(new Set([
    process.env.ProgramW6432,
    process.env.ProgramFiles,
    process.env.LOCALAPPDATA,
    path.join(os.homedir(), "AppData", "Local")
])).filter(Boolean);
const POPULAR_DISTRIBUTIONS = [
    "Eclipse Foundation",
    "Eclipse Adoptium",
    "Java",
    "Amazon Corretto",
    "Microsoft",
    path.join("SapMachine", "JDK"), // SAP Machine
];
function candidates() {
    return __awaiter(this, void 0, void 0, function* () {
        const ret = [];
        for (const programDir of PROGRAM_DIRS) {
            for (const distro of POPULAR_DISTRIBUTIONS) {
                const baseDir = path.join(programDir, distro);
                try {
                    const files = yield fs.promises.readdir(baseDir, { withFileTypes: true });
                    const homedirs = files.filter(file => file.isDirectory()).map(file => path.join(baseDir, file.name));
                    ret.push(...homedirs);
                }
                catch (error) {
                    (0, logger_1.log)(error);
                }
            }
        }
        return ret.filter(utils_1.looksLikeJavaHome);
    });
}
exports.candidates = candidates;
