"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSources = exports.getRuntime = exports.findRuntimes = exports.JAVA_FILENAME = exports.JAVAC_FILENAME = void 0;
const cp = __importStar(require("child_process"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const asdf = __importStar(require("./from/asdf"));
const envs = __importStar(require("./from/envs"));
const gradle = __importStar(require("./from/gradle"));
const homebrew = __importStar(require("./from/homebrew"));
const jabba = __importStar(require("./from/jabba"));
const jenv = __importStar(require("./from/jenv"));
const linux = __importStar(require("./from/linux"));
const macOS = __importStar(require("./from/macOS"));
const sdkman = __importStar(require("./from/sdkman"));
const windows = __importStar(require("./from/windows"));
const logger = __importStar(require("./logger"));
const utils_1 = require("./utils");
var utils_2 = require("./utils");
Object.defineProperty(exports, "JAVAC_FILENAME", { enumerable: true, get: function () { return utils_2.JAVAC_FILENAME; } });
Object.defineProperty(exports, "JAVA_FILENAME", { enumerable: true, get: function () { return utils_2.JAVA_FILENAME; } });
/**
 * Find Java runtime from all possible locations on your machine.
 *
 * @param options advanced options
 * @returns
 */
function findRuntimes(options) {
    return __awaiter(this, void 0, void 0, function* () {
        const store = new RuntimeStore();
        const candidates = [];
        const updateCandidates = (homedirs, updater) => {
            if (options === null || options === void 0 ? void 0 : options.withTags) {
                store.updateRuntimes(homedirs, updater);
            }
            else {
                candidates.push(...homedirs);
            }
        };
        // SDKMAN
        const fromSdkman = yield sdkman.candidates();
        updateCandidates(fromSdkman, (r) => (Object.assign(Object.assign({}, r), { isFromSDKMAN: true })));
        // platform-specific default location
        if (utils_1.isLinux) {
            updateCandidates(yield linux.candidates());
            updateCandidates(yield homebrew.candidates(homebrew.HOMEBREW_DIR_LINUX)); // Homebrew
        }
        if (utils_1.isMac) {
            updateCandidates(yield macOS.candidates());
            const hbOptPath = utils_1.isArm ? homebrew.HOMEBREW_DIR_APPLE_SILLICON : homebrew.HOMEBREW_DIR_INTEL;
            updateCandidates(yield homebrew.candidates(hbOptPath)); // Homebrew
        }
        if (utils_1.isWindows) {
            updateCandidates(yield windows.candidates());
        }
        // from env: JDK_HOME
        const fromJdkHome = yield envs.candidatesFromSpecificEnv("JDK_HOME");
        if (fromJdkHome) {
            updateCandidates([fromJdkHome], (r) => (Object.assign(Object.assign({}, r), { isJdkHomeEnv: true })));
        }
        // from env: JAVA_HOME
        const fromJavaHome = yield envs.candidatesFromSpecificEnv("JAVA_HOME");
        if (fromJavaHome) {
            updateCandidates([fromJavaHome], (r) => (Object.assign(Object.assign({}, r), { isJavaHomeEnv: true })));
        }
        // from env: PATH
        const fromPath = yield envs.candidatesFromPath();
        updateCandidates(fromPath, (r) => (Object.assign(Object.assign({}, r), { isInPathEnv: true })));
        // jEnv
        const fromJENV = yield jenv.candidates();
        updateCandidates(fromJENV, (r) => (Object.assign(Object.assign({}, r), { isFromJENV: true })));
        // jabba
        const fromJabba = yield jabba.candidates();
        updateCandidates(fromJabba, (r) => (Object.assign(Object.assign({}, r), { isFromJabba: true })));
        // asdf
        const fromASDF = yield asdf.candidates();
        updateCandidates(fromASDF, (r) => (Object.assign(Object.assign({}, r), { isFromASDF: true })));
        // Gradle
        const fromGradle = yield gradle.candidates();
        updateCandidates(fromGradle, (r) => (Object.assign(Object.assign({}, r), { isFromGradle: true })));
        // dedup and construct runtimes
        let runtimes = (options === null || options === void 0 ? void 0 : options.withTags) ? store.allRuntimes()
            : (0, utils_1.deDup)(candidates).map((homedir) => ({ homedir }));
        // verification
        if (true /* always check java binary */) {
            runtimes = yield Promise.all(runtimes.map(checkJavaFile));
            if (true /* java binary is required for a valid runtime */) {
                runtimes = runtimes.filter(r => r.isValid);
            }
        }
        if (options === null || options === void 0 ? void 0 : options.checkJavac) {
            runtimes = yield Promise.all(runtimes.map(checkJavacFile));
        }
        if (options === null || options === void 0 ? void 0 : options.withVersion) {
            runtimes = yield Promise.all(runtimes.map(parseVersion));
        }
        // clean up private fields by default
        for (const r of runtimes) {
            delete r.isValid;
        }
        return runtimes;
    });
}
exports.findRuntimes = findRuntimes;
/**
 * Verify if given directory contains a valid Java runtime, and provide details if it is.
 *
 * @param homedir home directory of a Java runtime
 * @param options
 * @returns
 */
function getRuntime(homedir, options) {
    return __awaiter(this, void 0, void 0, function* () {
        let runtime = { homedir };
        runtime = yield checkJavaFile(runtime);
        if (!runtime.isValid) {
            return undefined;
        }
        if (options === null || options === void 0 ? void 0 : options.checkJavac) {
            runtime = yield checkJavacFile(runtime);
        }
        if (options === null || options === void 0 ? void 0 : options.withVersion) {
            runtime = yield parseVersion(runtime);
        }
        if (options === null || options === void 0 ? void 0 : options.withTags) {
            const gList = yield gradle.candidates();
            if (gList.includes(homedir)) {
                runtime.isFromGradle = true;
            }
            const aList = yield asdf.candidates();
            if (aList.includes(homedir)) {
                runtime.isFromASDF = true;
            }
            const jList = yield jenv.candidates();
            if (jList.includes(homedir)) {
                runtime.isFromJENV = true;
            }
            const sList = yield sdkman.candidates();
            if (sList.includes(homedir)) {
                runtime.isFromSDKMAN = true;
            }
            const jbList = yield jabba.candidates();
            if (jbList.includes(homedir)) {
                runtime.isFromJabba = true;
            }
            const pList = yield envs.candidatesFromPath();
            if (pList.includes(homedir)) {
                runtime.isInPathEnv = true;
            }
            if ((yield envs.candidatesFromSpecificEnv("JAVA_HOME")) === homedir) {
                runtime.isJavaHomeEnv = true;
            }
            if ((yield envs.candidatesFromSpecificEnv("JDK_HOME")) === homedir) {
                runtime.isJdkHomeEnv = true;
            }
        }
        return runtime;
    });
}
exports.getRuntime = getRuntime;
/**
 * A utility to list all sources where given Java runtime is found.
 *
 * @param r given IJavaRuntime
 * @returns list of sources where given runtime is found.
 */
function getSources(r) {
    const sources = [];
    if (r.isJdkHomeEnv) {
        sources.push("JDK_HOME");
    }
    if (r.isJavaHomeEnv) {
        sources.push("JAVA_HOME");
    }
    if (r.isInPathEnv) {
        sources.push("PATH");
    }
    if (r.isFromSDKMAN) {
        sources.push("SDKMAN");
    }
    if (r.isFromJENV) {
        sources.push("jEnv");
    }
    if (r.isFromJabba) {
        sources.push("jabba");
    }
    if (r.isFromASDF) {
        sources.push("asdf");
    }
    if (r.isFromGradle) {
        sources.push("Gradle");
    }
    return sources;
}
exports.getSources = getSources;
function checkJavaFile(runtime) {
    return __awaiter(this, void 0, void 0, function* () {
        const { homedir } = runtime;
        const binary = path.join(homedir, "bin", utils_1.JAVA_FILENAME);
        try {
            yield fs.promises.access(binary, fs.constants.F_OK);
            runtime.isValid = true;
        }
        catch (error) {
            runtime.isValid = false;
        }
        return runtime;
    });
}
function checkJavacFile(runtime) {
    return __awaiter(this, void 0, void 0, function* () {
        const { homedir } = runtime;
        const binary = path.join(homedir, "bin", utils_1.JAVAC_FILENAME);
        try {
            yield fs.promises.access(binary, fs.constants.F_OK);
            runtime.hasJavac = true;
        }
        catch (error) {
            runtime.hasJavac = false;
        }
        return runtime;
    });
}
function parseVersion(runtime) {
    return __awaiter(this, void 0, void 0, function* () {
        const { homedir } = runtime;
        const releaseFile = path.join(homedir, "release");
        try {
            const content = yield fs.promises.readFile(releaseFile, { encoding: "utf-8" });
            const regexp = /^JAVA_VERSION="(.*)"/gm;
            const match = regexp.exec(content.toString());
            if (!match) {
                return runtime;
            }
            const java_version = match[1];
            const major = parseMajorVersion(java_version);
            runtime.version = {
                java_version,
                major
            };
        }
        catch (error) {
            logger.log(error);
        }
        if (runtime.version === undefined) {
            // fallback to check version by CLI
            try {
                runtime.version = yield checkJavaVersionByCLI(homedir);
            }
            catch (error) {
                logger.log(error);
            }
        }
        return runtime;
    });
}
/**
 * Get version by parsing `JAVA_HOME/bin/java -version`, make sure binary file exists.
 * @deprecated as a fallback when file "release" not found
 */
function checkJavaVersionByCLI(javaHome) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, _reject) => {
            const javaBin = path.join(javaHome, "bin", utils_1.JAVA_FILENAME); // assume java binary exists.
            cp.execFile(javaBin, ["-version"], {}, (_error, _stdout, stderr) => {
                const regexp = /version "(.*)"/g;
                const match = regexp.exec(stderr);
                if (!match) {
                    return resolve(undefined);
                }
                const java_version = match[1];
                const major = parseMajorVersion(java_version);
                resolve({
                    java_version,
                    major
                });
            });
        });
    });
}
function parseMajorVersion(version) {
    if (!version) {
        return 0;
    }
    // Ignore '1.' prefix for legacy Java versions
    if (version.startsWith("1.")) {
        version = version.substring(2);
    }
    // look into the interesting bits now
    const regexp = /\d+/g;
    const match = regexp.exec(version);
    let javaVersion = 0;
    if (match) {
        javaVersion = parseInt(match[0]);
    }
    return javaVersion;
}
class RuntimeStore {
    constructor() {
        this.map = new Map();
    }
    updateRuntimes(homedirs, updater) {
        for (const h of homedirs) {
            this.updateRuntime(h, updater);
        }
    }
    updateRuntime(homedir, updater) {
        var _a;
        const runtime = this.map.get(homedir) || { homedir };
        this.map.set(homedir, (_a = updater === null || updater === void 0 ? void 0 : updater(runtime)) !== null && _a !== void 0 ? _a : runtime);
    }
    allRuntimes() {
        return Array.from(this.map.values());
    }
}
