"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRealHome = exports.expandTilde = exports.deDup = exports.looksLikeJavaHome = exports.JAVAC_FILENAME = exports.JAVA_FILENAME = exports.isArm = exports.isLinux = exports.isMac = exports.isWindows = void 0;
const fs = __importStar(require("fs"));
const os_1 = require("os");
const path_1 = require("path");
const logger = __importStar(require("./logger"));
// platform
exports.isWindows = process.platform.indexOf("win") === 0;
exports.isMac = process.platform.indexOf("darwin") === 0;
exports.isLinux = process.platform.indexOf("linux") === 0;
// arch
exports.isArm = process.arch.indexOf("arm") === 0; // used to distinguish macOS Intel/Apple Sillicon
exports.JAVA_FILENAME = exports.isWindows ? "java.exe" : "java";
exports.JAVAC_FILENAME = exports.isWindows ? "javac.exe" : "javac";
function looksLikeJavaHome(dir) {
    const lower = dir.toLocaleLowerCase();
    return lower.includes("jdk") || lower.includes("java");
}
exports.looksLikeJavaHome = looksLikeJavaHome;
function deDup(arr) {
    return Array.from(new Set(arr));
}
exports.deDup = deDup;
function expandTilde(filepath) {
    if (filepath.charCodeAt(0) === 126 /* ~ */) {
        return (0, path_1.join)((0, os_1.homedir)(), filepath.slice(1));
    }
    else {
        return filepath;
    }
}
exports.expandTilde = expandTilde;
/**
 * Get real Java Home directory, deducted from real path of 'bin/java', with symbolic links resolved.
 * Mainly for Homebrew.
 * @param javaHomePathLike e.g. some-path supposed to have 'bin/java' under it.
 * @returns a valid java home
 */
function getRealHome(javaHomePathLike) {
    return __awaiter(this, void 0, void 0, function* () {
        const javaBinaryPath = expandTilde((0, path_1.join)(javaHomePathLike, "bin", exports.JAVA_FILENAME));
        try {
            const rp = yield fs.promises.realpath(javaBinaryPath);
            return (0, path_1.dirname)((0, path_1.dirname)(rp));
        }
        catch (error) {
            logger.log(error);
        }
        return undefined;
    });
}
exports.getRealHome = getRealHome;
